/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.hax;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.util.JsonUtils;

public class BFUVDeserializer
implements JsonDeserializer<BlockFaceUV> {
    public BlockFaceUV deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
        JsonObject jsonobject = p_deserialize_1_.getAsJsonObject();
        float[] afloat = this.parseUV(jsonobject);
        int i = this.parseRotation(jsonobject);
        return new BlockFaceUV(afloat, i);
    }

    protected int parseRotation(JsonObject object) {
        int i = JsonUtils.func_151208_a((JsonObject)object, (String)"rotation", (int)0);
        if (i >= 0 && i % 90 == 0 && i / 90 <= 3) {
            return i;
        }
        throw new JsonParseException("Invalid rotation " + i + " found, only 0/90/180/270 allowed");
    }

    @Nullable
    private float[] parseUV(JsonObject object) {
        if (!object.has("uv")) {
            return null;
        }
        JsonArray jsonarray = JsonUtils.func_151214_t((JsonObject)object, (String)"uv");
        if (jsonarray.size() != 4) {
            throw new JsonParseException("Expected 4 uv values, found: " + jsonarray.size());
        }
        float[] afloat = new float[4];
        for (int i = 0; i < afloat.length; ++i) {
            afloat[i] = JsonUtils.func_151220_d((JsonElement)jsonarray.get(i), (String)("uv[" + i + "]"));
        }
        return afloat;
    }
}

