/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.block;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.block.CustomStateMapper;
import epicsquid.mysticallib.block.IBlock;
import epicsquid.mysticallib.model.IModeledObject;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSaplingBase
extends BlockBush
implements IBlock,
IModeledObject,
IGrowable {
    @Nonnull
    private Item itemBlock;
    private List<ItemStack> drops;
    private boolean isOpaque = true;
    private boolean hasCustomModel = false;
    private boolean hasItems = true;
    private AxisAlignedBB box;
    private boolean isFlammable = false;
    private BlockRenderLayer layer = BlockRenderLayer.CUTOUT;
    private Supplier<WorldGenAbstractTree> treeGenerator;
    @Nonnull
    public String name;

    public BlockSaplingBase(@Nonnull String name, Supplier<WorldGenAbstractTree> treeGenerator) {
        this.name = name;
        this.treeGenerator = treeGenerator;
        this.setBox(new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f));
        this.func_149663_c(name);
        this.func_149672_a(SoundType.field_185850_c);
        this.setRegistryName(LibRegistry.getActiveModid(), name);
        this.func_149713_g(0);
        this.setOpacity(false);
        this.itemBlock = (Item)new ItemBlock((Block)this).setRegistryName(LibRegistry.getActiveModid(), name);
    }

    @Nonnull
    public BlockSaplingBase setFlammable(boolean flammable) {
        this.isFlammable = flammable;
        return this;
    }

    @Nonnull
    public BlockSaplingBase setResistance(float resistance) {
        super.func_149752_b(resistance);
        return this;
    }

    @Nonnull
    public BlockSaplingBase setDrops(@Nonnull List<ItemStack> drops) {
        this.drops = drops;
        return this;
    }

    @Nonnull
    public BlockSaplingBase setBox(@Nonnull AxisAlignedBB box) {
        this.box = box;
        return this;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return this.box;
    }

    @Nonnull
    public BlockSaplingBase setModelCustom(boolean custom) {
        this.hasCustomModel = custom;
        return this;
    }

    @Nonnull
    public BlockSaplingBase setHarvestReqs(@Nonnull String tool, int level) {
        this.setHarvestLevel(tool, level);
        return this;
    }

    @Nonnull
    public BlockSaplingBase setOpacity(boolean isOpaque) {
        this.isOpaque = isOpaque;
        return this;
    }

    @Nonnull
    public BlockSaplingBase setHasItem(boolean hasItem) {
        this.hasItems = hasItem;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockSaplingBase setLayer(@Nonnull BlockRenderLayer layer) {
        this.layer = layer;
        return this;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return this.isOpaque;
    }

    public boolean hasCustomModel() {
        return this.hasCustomModel;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        if (this.hasCustomModel) {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new CustomStateMapper());
        }
        if (!this.hasCustomModel) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
        }
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this));
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return this.layer;
    }

    @Override
    public Item getItemBlock() {
        return this.itemBlock;
    }

    @Override
    public ItemBlock setItemBlock(ItemBlock block) {
        this.itemBlock = block;
        return block;
    }

    @Nullable
    protected IBlockState getParentState() {
        return null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.drops != null && this.drops.size() > 0) {
            return this.drops.get(0).func_77973_b();
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.isFlammable || super.isFlammable(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isFlammable ? 100 : super.getFlammability(world, pos, face);
    }

    @Nonnull
    protected Class<? extends BakedModelBlock> getModelClass() {
        return this.getModelClass(0);
    }

    @Nonnull
    protected Class<? extends BakedModelBlock> getModelClass(int type) {
        return BakedModelBlock.class;
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        WorldGenerator worldgenerator = (WorldGenerator)this.treeGenerator.get();
        IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
        worldIn.func_180501_a(pos, iblockstate2, 4);
        if (!worldgenerator.func_180709_b(worldIn, rand, pos)) {
            worldIn.func_180501_a(pos, state, 4);
        }
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(worldIn, pos, state, rand);
            }
        }
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)BlockSapling.field_176479_b), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockSapling.field_176479_b});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b);
    }
}

