/*
 * Decompiled with CFR 0.152.
 */
package josephcsible.oreberries.worldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import josephcsible.oreberries.BlockOreberryBush;
import josephcsible.oreberries.proxy.CommonProxy;
import josephcsible.oreberries.worldgen.WorldGenOreberryBush;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreberriesWorldGen
implements IWorldGenerator {
    protected List<WorldGenOreberryBush> bushes = new ArrayList<WorldGenOreberryBush>();

    public OreberriesWorldGen() {
        for (BlockOreberryBush block : CommonProxy.oreberryBushBlocks) {
            this.bushes.add(new WorldGenOreberryBush(block));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_72912_H().func_76067_t() != WorldType.field_77138_c) {
            this.generateOreBushes(random, chunkX * 16 + 8, chunkZ * 16 + 8, world);
        }
    }

    protected void generateOreBushes(Random random, int xChunk, int zChunk, World world) {
        for (WorldGenOreberryBush gen : this.bushes) {
            if (!gen.oreberryConfig.dimensions.contains(world.field_73011_w.getDimension())) continue;
            this.generateOreBush(random, xChunk, zChunk, world, gen, gen.oreberryConfig.getPreferredHeight(world), gen.oreberryConfig.getMaxHeight(world), gen.oreberryConfig.minHeight);
        }
    }

    protected void generateOreBush(Random random, int xChunk, int zChunk, World world, WorldGenOreberryBush bush, int y, int heightLimit, int depthLimit) {
        if (bush.oreberryConfig.rarity > 0 && random.nextInt(bush.oreberryConfig.rarity) == 0) {
            for (int i = 0; i < bush.oreberryConfig.density; ++i) {
                BlockPos pos = this.findAdequateLocation(world, xChunk + random.nextInt(16), y, zChunk + random.nextInt(16), heightLimit, depthLimit);
                if (pos == null) continue;
                bush.func_180709_b(world, random, pos);
            }
        }
    }

    protected BlockPos findAdequateLocation(World world, int x, int y, int z, int heightLimit, int depthLimit) {
        BlockPos pos = new BlockPos(x, y, z);
        do {
            if (!world.func_175623_d(pos) || world.func_175623_d(pos.func_177984_a())) continue;
            return pos.func_177984_a();
        } while ((pos = pos.func_177984_a()).func_177956_o() < heightLimit);
        pos = new BlockPos(x, y, z);
        do {
            if (!world.func_175623_d(pos) || world.func_175623_d(pos.func_177977_b())) continue;
            return pos.func_177977_b();
        } while ((pos = pos.func_177977_b()).func_177956_o() > depthLimit);
        return null;
    }
}

