/*
 * Decompiled with CFR 0.152.
 */
package josephcsible.oreberries.proxy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import josephcsible.oreberries.BlockOreberryBush;
import josephcsible.oreberries.OreberriesMod;
import josephcsible.oreberries.RecipeUtils;
import josephcsible.oreberries.VillagerTinkerTrades;
import josephcsible.oreberries.config.GeneralConfig;
import josephcsible.oreberries.config.OreberriesJson;
import josephcsible.oreberries.config.OreberryConfig;
import josephcsible.oreberries.item.ItemNugget;
import josephcsible.oreberries.worldgen.OreberriesWorldGen;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Triple;

@Mod.EventBusSubscriber
public class CommonProxy {
    public static final List<BlockOreberryBush> oreberryBushBlocks = new ArrayList<BlockOreberryBush>();
    protected static final List<ItemNugget> nuggets = new ArrayList<ItemNugget>();
    public static final CreativeTabs creativeTab = new CreativeTabs("oreberries"){

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_78016_d() {
            return oreberryBushBlocks.isEmpty() ? ItemStack.field_190927_a : new ItemStack(Item.func_150898_a((Block)oreberryBushBlocks.get(0)));
        }
    };

    public void preInit(FMLPreInitializationEvent event) {
        OreberriesMod.logger = event.getModLog();
        File jsonFile = new File(event.getModConfigurationDirectory(), "oreberries.json");
        JsonObject json = OreberriesJson.read(jsonFile);
        for (Map.Entry entry : json.entrySet()) {
            String name = (String)entry.getKey();
            OreberryConfig oreberryConfig = new OreberryConfig(name, (JsonObject)entry.getValue());
            if (oreberryConfig.smeltingResultNugget != null) {
                nuggets.add(new ItemNugget(name, oreberryConfig.smeltingResultNugget));
            }
            oreberryBushBlocks.add(new BlockOreberryBush(name, oreberryConfig));
        }
        if (OreberriesJson.needsWrite || GeneralConfig.rewriteJson) {
            json = new JsonObject();
            for (BlockOreberryBush block : oreberryBushBlocks) {
                json.add(block.config.name, (JsonElement)block.config.toJson());
            }
            OreberriesJson.write(jsonFile, (JsonElement)json);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (BlockOreberryBush block : oreberryBushBlocks) {
            registry.register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public static void registerVillagerProfessions(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        if (!GeneralConfig.enableVillager) {
            return;
        }
        VillagerRegistry.VillagerProfession prof = new VillagerRegistry.VillagerProfession("oreberries:tinker", "oreberries:textures/entity/villager/tinker.png", "minecraft:textures/entity/zombie_villager/zombie_villager.png");
        event.getRegistry().register((IForgeRegistryEntry)prof);
        new VillagerRegistry.VillagerCareer(prof, "tinker").addTrade(1, new EntityVillager.ITradeList[]{new VillagerTinkerTrades()});
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        for (ItemNugget item : nuggets) {
            registry.register((IForgeRegistryEntry)item);
            for (String oredictName : item.config.oredictNames) {
                OreDictionary.registerOre((String)oredictName, (Item)item);
            }
        }
        for (BlockOreberryBush block : oreberryBushBlocks) {
            registry.registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemBlock(block){

                public String func_77653_i(ItemStack stack) {
                    return this.field_150939_a.func_149732_F();
                }
            }.setRegistryName(block.getRegistryName()), block.berries});
            for (String oredictName : block.config.oredictNames) {
                OreDictionary.registerOre((String)oredictName, (Item)block.berries);
            }
        }
    }

    public void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreberriesWorldGen(), (int)0);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        for (ItemNugget nugget : nuggets) {
            for (String ingotName : nugget.config.ingotNames) {
                Triple<String, String, String> splitName = RecipeUtils.splitItemName(ingotName);
                if (splitName == null) continue;
                if (splitName.getLeft() == null) {
                    registry.register(new ShapedOreRecipe(null, new ItemStack((Item)nugget, 9), new Object[]{"i", Character.valueOf('i'), splitName.getMiddle()}).setRegistryName(RecipeUtils.getNewRecipeName()));
                    continue;
                }
                ItemStack stack = RecipeUtils.getItemFromName(splitName);
                if (stack == null) continue;
                if (!nugget.addedIngotRecipe) {
                    nugget.addedIngotRecipe = true;
                    GameRegistry.addShapedRecipe((ResourceLocation)RecipeUtils.getNewRecipeName(), null, (ItemStack)stack, (Object[])new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), new ItemStack((Item)nugget)});
                }
                GameRegistry.addShapedRecipe((ResourceLocation)RecipeUtils.getNewRecipeName(), null, (ItemStack)new ItemStack((Item)nugget, 9), (Object[])new Object[]{"i", Character.valueOf('i'), stack});
            }
        }
        for (BlockOreberryBush block : oreberryBushBlocks) {
            ItemStack stack;
            Triple<String, String, String> name = RecipeUtils.splitItemName(block.config.smeltingResultString);
            if (name == null || name.getLeft() == null || (stack = RecipeUtils.getItemFromName(name)) == null) continue;
            GameRegistry.addSmelting((Item)block.berries, (ItemStack)stack, (float)0.2f);
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        block0: for (ItemNugget nugget : nuggets) {
            if (nugget.addedIngotRecipe) continue;
            for (String ingotName : nugget.config.ingotNames) {
                ItemStack stack;
                Triple<String, String, String> splitName = RecipeUtils.splitItemName(ingotName);
                if (splitName == null || splitName.getLeft() != null || (stack = RecipeUtils.getItemFromOredict((String)splitName.getMiddle(), null)) == null) continue;
                nugget.addedIngotRecipe = true;
                GameRegistry.addShapedRecipe((ResourceLocation)RecipeUtils.getNewRecipeName(), null, (ItemStack)stack, (Object[])new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), new ItemStack((Item)nugget)});
                continue block0;
            }
        }
        for (BlockOreberryBush block : oreberryBushBlocks) {
            ItemStack stack;
            Triple<String, String, String> name = RecipeUtils.splitItemName(block.config.smeltingResultString);
            if (name == null || name.getLeft() != null || (stack = RecipeUtils.getItemFromOredict((String)name.getMiddle(), block.berries)) == null) continue;
            GameRegistry.addSmelting((Item)block.berries, (ItemStack)stack, (float)0.2f);
        }
    }

    @SubscribeEvent
    public static void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("oreberries")) {
            ConfigManager.sync((String)"oreberries", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public boolean isOreberryBushOpaqueCube(IBlockState state) {
        return false;
    }

    @SubscribeEvent
    public static void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        if (block instanceof BlockOreberryBush && (Integer)state.func_177229_b((IProperty)BlockOreberryBush.AGE) >= 3) {
            event.getDrops().add(((BlockOreberryBush)block).getBerriesStack(event.getWorld().field_73012_v));
        }
    }
}

