/*
 * Decompiled with CFR 0.152.
 */
package josephcsible.oreberries.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import josephcsible.oreberries.config.NuggetConfig;
import josephcsible.oreberries.item.ItemNugget;
import net.minecraft.init.Blocks;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class OreberryConfig {
    public final String name;
    public final String bushName;
    public final String berryName;
    public final String color;
    @Nullable
    public final String tooltip;
    public final List<String> oredictNames;
    @Nullable
    public final NuggetConfig smeltingResultNugget;
    @Nullable
    public final String smeltingResultString;
    @Nullable
    public final String special;
    public final boolean growsInLight;
    public final boolean tradeable;
    public final int rarity;
    public final int density;
    public final int minHeight;
    @Nullable
    protected final Integer preferredHeight;
    @Nullable
    protected final Integer maxHeight;
    public final int sizeChance;
    public final List<String> replaceBlocks;
    public final List<Integer> dimensions;
    public final int minDrops;
    public final int maxDrops;
    private static final List<String> defaultReplaceBlocks = Collections.unmodifiableList(Arrays.asList(Blocks.field_150348_b.getRegistryName().toString(), Blocks.field_150349_c.getRegistryName().toString(), Blocks.field_150346_d.getRegistryName().toString(), Blocks.field_150355_j.getRegistryName().toString(), Blocks.field_150354_m.getRegistryName().toString(), Blocks.field_150351_n.getRegistryName().toString(), Blocks.field_150433_aE.getRegistryName().toString()));
    private static final List<Integer> defaultDimensions = Collections.unmodifiableList(Arrays.asList(0));

    static String firstUpper(String s) {
        if (s.isEmpty()) {
            return "";
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public OreberryConfig(String name, JsonObject json) {
        Gson gson = new Gson();
        this.name = name;
        JsonElement jsonBushName = json.get("bushName");
        this.bushName = jsonBushName == null ? this.getDefaultBushName() : jsonBushName.getAsString();
        JsonElement jsonBerryName = json.get("berryName");
        this.berryName = jsonBerryName == null ? this.getDefaultBerryName() : jsonBerryName.getAsString();
        JsonElement jsonColor = json.get("color");
        this.color = jsonColor == null ? this.getDefaultColor() : jsonColor.getAsString();
        JsonElement jsonTooltip = json.get("tooltip");
        this.tooltip = jsonTooltip == null || jsonTooltip.isJsonNull() ? null : jsonTooltip.getAsString();
        JsonElement jsonOredictNames = json.get("oredictNames");
        this.oredictNames = jsonOredictNames == null ? this.getDefaultOredictNames() : Arrays.asList((Object[])gson.fromJson(jsonOredictNames, String[].class));
        JsonElement jsonSmeltingResult = json.get("smeltingResult");
        if (jsonSmeltingResult == null) {
            this.smeltingResultNugget = null;
            this.smeltingResultString = this.getDefaultSmeltingResult();
        } else if (jsonSmeltingResult.isJsonNull()) {
            this.smeltingResultNugget = null;
            this.smeltingResultString = null;
        } else if (jsonSmeltingResult.isJsonObject()) {
            this.smeltingResultNugget = new NuggetConfig(this, (JsonObject)jsonSmeltingResult);
            this.smeltingResultString = ItemNugget.getFullName(name);
        } else {
            this.smeltingResultNugget = null;
            this.smeltingResultString = jsonSmeltingResult.getAsString();
        }
        JsonElement jsonSpecial = json.get("special");
        this.special = jsonSpecial == null || jsonSpecial.isJsonNull() ? null : jsonSpecial.getAsString();
        JsonElement jsonGrowsInLight = json.get("growsInLight");
        this.growsInLight = jsonGrowsInLight == null ? this.getDefaultGrowsInLight() : jsonGrowsInLight.getAsBoolean();
        JsonElement jsonTradeable = json.get("tradeable");
        this.tradeable = jsonTradeable == null ? this.getDefaultTradeable() : jsonTradeable.getAsBoolean();
        JsonElement jsonRarity = json.get("rarity");
        this.rarity = jsonRarity == null ? this.getDefaultRarity() : jsonRarity.getAsInt();
        JsonElement jsonDensity = json.get("density");
        this.density = jsonDensity == null ? this.getDefaultDensity() : jsonDensity.getAsInt();
        JsonElement jsonMinHeight = json.get("minHeight");
        this.minHeight = jsonMinHeight == null ? this.getDefaultMinHeight() : jsonMinHeight.getAsInt();
        JsonElement jsonPreferredHeight = json.get("preferredHeight");
        this.preferredHeight = jsonPreferredHeight == null || jsonPreferredHeight.isJsonNull() ? null : Integer.valueOf(jsonPreferredHeight.getAsInt());
        JsonElement jsonMaxHeight = json.get("maxHeight");
        this.maxHeight = jsonMaxHeight == null || jsonMaxHeight.isJsonNull() ? null : Integer.valueOf(jsonMaxHeight.getAsInt());
        JsonElement jsonSizeChance = json.get("sizeChance");
        this.sizeChance = jsonSizeChance == null ? this.getDefaultSizeChance() : jsonSizeChance.getAsInt();
        JsonElement jsonReplaceBlocks = json.get("replaceBlocks");
        this.replaceBlocks = jsonReplaceBlocks == null ? this.getDefaultReplaceBlocks() : Arrays.asList((Object[])gson.fromJson(jsonReplaceBlocks, String[].class));
        JsonElement jsonDimensions = json.get("dimensions");
        this.dimensions = jsonDimensions == null ? this.getDefaultDimensions() : Arrays.asList((Object[])gson.fromJson(jsonDimensions, Integer[].class));
        JsonElement jsonMinDrops = json.get("minDrops");
        this.minDrops = jsonMinDrops == null ? this.getDefaultMinDrops() : jsonMinDrops.getAsInt();
        JsonElement jsonMaxDrops = json.get("maxDrops");
        this.maxDrops = jsonMaxDrops == null ? this.getDefaultMaxDrops() : jsonMaxDrops.getAsInt();
    }

    public String getDefaultBushName() {
        return I18n.func_74837_a((String)"tile.oreberries.oreberry_bush.name", (Object[])new Object[]{this.name});
    }

    public String getDefaultBerryName() {
        return I18n.func_74837_a((String)"item.oreberries.oreberry.name", (Object[])new Object[]{this.name});
    }

    public String getDefaultColor() {
        return "#FFFFFF";
    }

    public List<String> getDefaultOredictNames() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("nugget" + OreberryConfig.firstUpper(this.name));
        return retval;
    }

    public String getDefaultSmeltingResult() {
        return "nugget" + OreberryConfig.firstUpper(this.name);
    }

    public boolean getDefaultGrowsInLight() {
        return false;
    }

    public boolean getDefaultTradeable() {
        return true;
    }

    public int getDefaultRarity() {
        return 6;
    }

    public int getDefaultDensity() {
        return 1;
    }

    public int getDefaultMinHeight() {
        return 0;
    }

    public int getPreferredHeight(World world) {
        if (this.preferredHeight == null) {
            return (this.minHeight + this.getMaxHeight(world)) / 2;
        }
        return this.preferredHeight;
    }

    public int getMaxHeight(World world) {
        if (this.maxHeight == null) {
            return world.func_181545_F();
        }
        return this.maxHeight;
    }

    public int getDefaultSizeChance() {
        return 12;
    }

    public List<String> getDefaultReplaceBlocks() {
        return defaultReplaceBlocks;
    }

    public List<Integer> getDefaultDimensions() {
        return defaultDimensions;
    }

    public int getDefaultMinDrops() {
        return 1;
    }

    public int getDefaultMaxDrops() {
        return 3;
    }

    public JsonObject toJson() {
        Gson gson = new Gson();
        JsonObject json = new JsonObject();
        if (!this.bushName.equals(this.getDefaultBushName())) {
            json.addProperty("bushName", this.bushName);
        }
        if (!this.berryName.equals(this.getDefaultBerryName())) {
            json.addProperty("berryName", this.berryName);
        }
        if (!this.color.equals(this.getDefaultColor())) {
            json.addProperty("color", this.color);
        }
        if (this.tooltip != null) {
            json.addProperty("tooltip", this.tooltip);
        }
        if (!this.oredictNames.equals(this.getDefaultOredictNames())) {
            json.add("oredictNames", gson.toJsonTree(this.oredictNames));
        }
        if (this.smeltingResultNugget != null) {
            json.add("smeltingResult", (JsonElement)this.smeltingResultNugget.toJson());
        } else if (!this.getDefaultSmeltingResult().equals(this.smeltingResultString)) {
            json.addProperty("smeltingResult", this.smeltingResultString);
        }
        if (this.special != null) {
            json.addProperty("special", this.special);
        }
        if (this.growsInLight != this.getDefaultGrowsInLight()) {
            json.addProperty("growsInLight", Boolean.valueOf(this.growsInLight));
        }
        if (this.tradeable != this.getDefaultTradeable()) {
            json.addProperty("tradeable", Boolean.valueOf(this.tradeable));
        }
        if (this.rarity != this.getDefaultRarity()) {
            json.addProperty("rarity", (Number)this.rarity);
        }
        if (this.density != this.getDefaultDensity()) {
            json.addProperty("density", (Number)this.density);
        }
        if (this.minHeight != this.getDefaultMinHeight()) {
            json.addProperty("minHeight", (Number)this.minHeight);
        }
        if (this.preferredHeight != null) {
            json.addProperty("preferredHeight", (Number)this.preferredHeight);
        }
        if (this.maxHeight != null) {
            json.addProperty("maxHeight", (Number)this.maxHeight);
        }
        if (this.sizeChance != this.getDefaultSizeChance()) {
            json.addProperty("sizeChance", (Number)this.sizeChance);
        }
        if (!this.replaceBlocks.equals(this.getDefaultReplaceBlocks())) {
            json.add("replaceBlocks", gson.toJsonTree(this.replaceBlocks));
        }
        if (!this.dimensions.equals(this.getDefaultDimensions())) {
            json.add("dimensions", gson.toJsonTree(this.dimensions));
        }
        if (this.minDrops != this.getDefaultMinDrops()) {
            json.addProperty("minDrops", (Number)this.minDrops);
        }
        if (this.maxDrops != this.getDefaultMaxDrops()) {
            json.addProperty("maxDrops", (Number)this.maxDrops);
        }
        return json;
    }
}

