/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.overworld.block.leaves;

import com.google.common.collect.Lists;
import com.progwml6.natura.common.block.base.BlockLeavesBase;
import com.progwml6.natura.library.NaturaRegistry;
import com.progwml6.natura.overworld.NaturaOverworld;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.mantle.block.EnumBlock;

public class BlockRedwoodLeaves
extends BlockLeavesBase {
    public static final PropertyEnum<RedwoodType> TYPE = PropertyEnum.func_177709_a((String)"type", RedwoodType.class);

    public BlockRedwoodLeaves() {
        this.func_149647_a((CreativeTabs)NaturaRegistry.tabWorld);
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
    }

    public void func_180650_b(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            boolean nearbyTree = false;
            int range = 4;
            for (int posX = pos.func_177958_n() - range; posX <= pos.func_177958_n() + range; ++posX) {
                for (int posY = pos.func_177956_o() - range; posY <= pos.func_177956_o() + range; ++posY) {
                    for (int posZ = pos.func_177952_p() - range; posZ <= pos.func_177952_p() + range; ++posZ) {
                        BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
                        IBlockState iblockstate = worldIn.func_180495_p((BlockPos)mutableblockpos.func_181079_c(posX, posY, posZ));
                        Block block = iblockstate.func_177230_c();
                        if (block == null || !block.canSustainLeaves(iblockstate, (IBlockAccess)worldIn, pos.func_177982_a(posX, posY, posZ))) continue;
                        nearbyTree = true;
                    }
                }
            }
            if (!nearbyTree) {
                this.destroy(worldIn, pos);
            }
        }
    }

    private void destroy(World worldIn, BlockPos pos) {
        this.func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
        worldIn.func_175698_g(pos);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (RedwoodType type : RedwoodType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type)))));
        }
    }

    protected int func_176232_d(IBlockState state) {
        return 25;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)NaturaOverworld.redwoodSapling);
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
    }

    public int func_180651_a(IBlockState state) {
        return ((RedwoodType)((Object)state.func_177229_b(TYPE))).ordinal() & 3;
    }

    protected ItemStack func_180643_i(@Nonnull IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, ((RedwoodType)((Object)state.func_177229_b(TYPE))).ordinal() & 3);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, field_176236_b, field_176237_a});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        int type = meta % 4;
        if (type < 0 || type >= RedwoodType.values().length) {
            type = 0;
        }
        RedwoodType logtype = RedwoodType.values()[type];
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)logtype)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((RedwoodType)((Object)state.func_177229_b(TYPE))).ordinal() & 3;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            meta |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        return Lists.newArrayList((Object[])new ItemStack[]{this.func_180643_i(state)});
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public static enum RedwoodType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        NORMAL;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

