/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.world.structmatcher;

import io.github.phantamanta44.libnine.util.math.MathUtils;
import io.github.phantamanta44.libnine.util.tuple.IPair;
import io.github.phantamanta44.libnine.util.world.WorldBlockPos;
import io.github.phantamanta44.libnine.util.world.structmatcher.IStructureMatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class StructureMatcherCuboid
implements IStructureMatcher {
    private final CorePosition corePos;
    private final IStructureMatcher wallMatcher;
    private final IStructureMatcher bodyMatcher;
    private int volumeMin = -1;
    private int volumeMax = -1;
    @Nullable
    private IStructureMatcher floorMatcher;
    @Nullable
    private IStructureMatcher ceilMatcher;
    @Nullable
    private IStructureMatcher wallEdgeMatcher;
    @Nullable
    private IStructureMatcher floorEdgeMatcher;
    @Nullable
    private IStructureMatcher ceilEdgeMatcher;
    @Nullable
    private CuboidMatcher postTest;

    public StructureMatcherCuboid(CorePosition corePos, IStructureMatcher wallMatcher, IStructureMatcher bodyMatcher) {
        this.corePos = corePos;
        this.wallMatcher = wallMatcher;
        this.bodyMatcher = bodyMatcher;
    }

    public void setMinVolume(int volume) {
        this.volumeMin = volume;
    }

    public void setMaxVolume(int volume) {
        this.volumeMax = volume;
    }

    public void setFloorMatcher(IStructureMatcher matcher) {
        this.floorMatcher = matcher;
    }

    public void setCeilMatcher(IStructureMatcher matcher) {
        this.ceilMatcher = matcher;
    }

    public void setWallEdgeMatcher(IStructureMatcher matcher) {
        this.wallEdgeMatcher = matcher;
    }

    public void setFloorEdgeMatcher(IStructureMatcher matcher) {
        this.floorEdgeMatcher = matcher;
    }

    public void setCeilEdgeMatcher(IStructureMatcher matcher) {
        this.ceilEdgeMatcher = matcher;
    }

    public void setPostTest(CuboidMatcher matcher) {
        this.postTest = matcher;
    }

    @Override
    public boolean testStructure(WorldBlockPos basePos, List<Vec3i> components) {
        IPair<Vec3i, Vec3i> minMax = MathUtils.computeCuboid(components);
        Vec3i min = minMax.getA();
        Vec3i max = minMax.getB();
        int minX = min.func_177958_n();
        int minY = min.func_177956_o();
        int minZ = min.func_177952_p();
        int maxX = max.func_177958_n();
        int maxY = max.func_177956_o();
        int maxZ = max.func_177952_p();
        int dx = maxX - minX + 1;
        int dy = maxY - minY + 1;
        int dz = maxZ - minZ + 1;
        int volume = (dx - 2) * (dy - 2) * (dz - 2);
        if (this.volumeMin > 0 && volume < this.volumeMin || this.volumeMax > 0 && volume > this.volumeMax || !this.corePos.isCorePositionValid(min, max)) {
            return false;
        }
        ArrayList<Vec3i> floor = new ArrayList<Vec3i>();
        ArrayList<Vec3i> walls = new ArrayList<Vec3i>();
        ArrayList<Vec3i> ceil = new ArrayList<Vec3i>();
        ArrayList<Vec3i> body = new ArrayList<Vec3i>();
        for (Vec3i pos : components) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            if (y == minY) {
                floor.add(pos);
                continue;
            }
            if (y == maxY) {
                ceil.add(pos);
                continue;
            }
            if (x == minX || x == maxX || z == minZ || z == maxZ) {
                walls.add(pos);
                continue;
            }
            body.add(pos);
        }
        int surfaceXZ = dx * dz;
        if (floor.size() != surfaceXZ || ceil.size() != surfaceXZ || walls.size() != (dy - 2) * (dx * 2 + dz * 2 - 4)) {
            return false;
        }
        if (this.floorMatcher != null) {
            if (StructureMatcherCuboid.testFailsXZ(basePos, floor, minX, minZ, maxX, maxZ, this.floorMatcher, this.floorEdgeMatcher)) {
                return false;
            }
        } else {
            walls.addAll(floor);
        }
        if (this.ceilMatcher != null) {
            if (StructureMatcherCuboid.testFailsXZ(basePos, ceil, minX, minZ, maxX, maxZ, this.ceilMatcher, this.ceilEdgeMatcher)) {
                return false;
            }
        } else {
            walls.addAll(ceil);
        }
        if (this.wallEdgeMatcher != null) {
            Iterator iter = walls.iterator();
            ArrayList<Vec3i> wallEdge = new ArrayList<Vec3i>();
            while (iter.hasNext()) {
                Vec3i pos = (Vec3i)iter.next();
                if (pos.func_177958_n() == minX || pos.func_177958_n() == maxX) {
                    if (pos.func_177956_o() != minY && pos.func_177956_o() != maxY && pos.func_177952_p() != minZ && pos.func_177952_p() != maxZ) continue;
                    wallEdge.add(pos);
                    iter.remove();
                    continue;
                }
                if (pos.func_177956_o() != minY && pos.func_177956_o() != maxY || pos.func_177952_p() != minZ && pos.func_177952_p() != maxZ) continue;
                wallEdge.add(pos);
                iter.remove();
            }
            if (!this.wallEdgeMatcher.testStructure(basePos, wallEdge)) {
                return false;
            }
        }
        if (!this.wallMatcher.testStructure(basePos, walls) || !this.bodyMatcher.testStructure(basePos, body)) {
            return false;
        }
        return this.postTest == null || this.postTest.testCuboid(basePos.getWorld(), basePos.getPos().func_177971_a(min), basePos.getPos().func_177971_a(max));
    }

    private static boolean testFailsXZ(WorldBlockPos basePos, List<Vec3i> plane, int minX, int minZ, int maxX, int maxZ, IStructureMatcher matcher, @Nullable IStructureMatcher edgeMatcher) {
        if (edgeMatcher != null) {
            Iterator<Vec3i> iter = plane.iterator();
            ArrayList<Vec3i> edge = new ArrayList<Vec3i>();
            while (iter.hasNext()) {
                Vec3i pos = iter.next();
                if (pos.func_177958_n() != minX && pos.func_177958_n() != maxX && pos.func_177952_p() != minZ && pos.func_177952_p() != maxZ) continue;
                edge.add(pos);
                iter.remove();
            }
            if (!edgeMatcher.testStructure(basePos, edge)) {
                return true;
            }
        }
        return !matcher.testStructure(basePos, plane);
    }

    public static enum CorePosition {
        ANYWHERE{

            @Override
            public boolean isCorePositionValid(Vec3i min, Vec3i max) {
                return min.func_177958_n() == 0 || min.func_177956_o() == 0 || min.func_177952_p() == 0 || max.func_177958_n() == 0 || max.func_177956_o() == 0 || max.func_177952_p() == 0;
            }
        }
        ,
        IN_FACE{

            @Override
            public boolean isCorePositionValid(Vec3i min, Vec3i max) {
                if (min.func_177958_n() == 0 || max.func_177958_n() == 0) {
                    return min.func_177956_o() != 0 && max.func_177956_o() != 0 && min.func_177952_p() != 0 && max.func_177952_p() != 0;
                }
                if (min.func_177956_o() == 0 || max.func_177956_o() == 0) {
                    return min.func_177952_p() != 0 && max.func_177952_p() != 0;
                }
                return min.func_177952_p() == 0 || max.func_177952_p() == 0;
            }
        }
        ,
        IN_WALL_OR_EDGE{

            @Override
            public boolean isCorePositionValid(Vec3i min, Vec3i max) {
                return (min.func_177958_n() == 0 || max.func_177958_n() == 0 || min.func_177952_p() == 0 || max.func_177952_p() == 0) && min.func_177956_o() != 0 && max.func_177956_o() != 0;
            }
        }
        ,
        IN_WALL{

            @Override
            public boolean isCorePositionValid(Vec3i min, Vec3i max) {
                if (min.func_177956_o() == 0 || max.func_177956_o() == 0) {
                    return false;
                }
                if (min.func_177958_n() == 0 || min.func_177956_o() == 0) {
                    return min.func_177952_p() != 0 && max.func_177952_p() != 0;
                }
                return min.func_177952_p() == 0 || max.func_177952_p() == 0;
            }
        }
        ,
        IN_FLOOR_OR_EDGE{

            @Override
            public boolean isCorePositionValid(Vec3i min, Vec3i max) {
                return min.func_177956_o() == 0;
            }
        }
        ,
        IN_FLOOR{

            @Override
            public boolean isCorePositionValid(Vec3i min, Vec3i max) {
                return min.func_177956_o() == 0 && min.func_177958_n() != 0 && max.func_177958_n() != 0 && min.func_177952_p() != 0 && max.func_177952_p() != 0;
            }
        }
        ,
        IN_CEIL_OR_EDGE{

            @Override
            public boolean isCorePositionValid(Vec3i min, Vec3i max) {
                return max.func_177956_o() == 0;
            }
        }
        ,
        IN_CEIL{

            @Override
            public boolean isCorePositionValid(Vec3i min, Vec3i max) {
                return max.func_177956_o() == 0 && min.func_177958_n() != 0 && max.func_177958_n() != 0 && min.func_177952_p() != 0 && max.func_177952_p() != 0;
            }
        };


        public abstract boolean isCorePositionValid(Vec3i var1, Vec3i var2);
    }

    @FunctionalInterface
    public static interface CuboidMatcher {
        public boolean testCuboid(World var1, BlockPos var2, BlockPos var3);
    }
}

