/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.world;

import com.google.common.collect.ImmutableList;
import io.github.phantamanta44.libnine.util.ImpossibilityRealizedException;
import io.github.phantamanta44.libnine.util.format.ILocalizable;
import java.util.function.UnaryOperator;
import net.minecraft.util.EnumFacing;

public enum BlockSide implements ILocalizable
{
    FRONT(f -> f),
    BACK(EnumFacing::func_176734_d),
    UP(f -> EnumFacing.UP),
    LEFT(EnumFacing::func_176746_e),
    DOWN(f -> EnumFacing.DOWN),
    RIGHT(EnumFacing::func_176735_f);

    public static final ImmutableList<BlockSide> VALUES;
    private final UnaryOperator<EnumFacing> transformer;

    private BlockSide(UnaryOperator<EnumFacing> transformer) {
        this.transformer = transformer;
    }

    public EnumFacing getDirection(EnumFacing front) {
        return (EnumFacing)this.transformer.apply(front);
    }

    public static BlockSide fromDirection(EnumFacing front, EnumFacing face) {
        for (BlockSide side : BlockSide.values()) {
            if (side.getDirection(front) != face) continue;
            return side;
        }
        throw new ImpossibilityRealizedException();
    }

    @Override
    public String getTranslationKey() {
        switch (this) {
            case FRONT: {
                return "libnine.info.block_side.front";
            }
            case BACK: {
                return "libnine.info.block_side.back";
            }
            case UP: {
                return "libnine.info.block_side.up";
            }
            case LEFT: {
                return "libnine.info.block_side.left";
            }
            case DOWN: {
                return "libnine.info.block_side.down";
            }
            case RIGHT: {
                return "libnine.info.block_side.right";
            }
        }
        throw new ImpossibilityRealizedException();
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])BlockSide.values());
    }
}

