/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.data.serialization;

import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.serialization.ISerializationProvider;
import io.github.phantamanta44.libnine.util.function.ITriConsumer;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.nbt.NBTTagCompound;

public class LambdaSerializer<T>
implements ISerializationProvider<T> {
    private final Class<T> type;
    private final ITriConsumer<NBTTagCompound, String, T> writerNbt;
    private final BiFunction<NBTTagCompound, String, T> readerNbt;
    private final BiConsumer<ByteUtils.Writer, T> writerBytes;
    private final Function<ByteUtils.Reader, T> readerBytes;

    public LambdaSerializer(Class<T> type, ITriConsumer<NBTTagCompound, String, T> writerNbt, BiFunction<NBTTagCompound, String, T> readerNbt, BiConsumer<ByteUtils.Writer, T> writerBytes, Function<ByteUtils.Reader, T> readerBytes) {
        this.type = type;
        this.writerNbt = writerNbt;
        this.readerNbt = readerNbt;
        this.writerBytes = writerBytes;
        this.readerBytes = readerBytes;
    }

    @Override
    public Class<T> getSerializationType() {
        return this.type;
    }

    @Override
    public void serializeNBT(T obj, String key, NBTTagCompound tag) {
        this.writerNbt.accept(tag, key, obj);
    }

    @Override
    public T deserializeNBT(String key, NBTTagCompound tag) {
        return this.readerNbt.apply(tag, key);
    }

    @Override
    public void serializeBytes(T obj, ByteUtils.Writer data) {
        this.writerBytes.accept(data, (ByteUtils.Writer)obj);
    }

    @Override
    public T deserializeBytes(ByteUtils.Reader data) {
        return this.readerBytes.apply(data);
    }
}

