/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.component.multiblock;

import io.github.phantamanta44.libnine.component.multiblock.IMultiBlockUnit;
import io.github.phantamanta44.libnine.component.multiblock.MultiBlockConnectable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import net.minecraft.util.EnumFacing;

public class MultiBlockIterator<T extends IMultiBlockUnit<T>>
implements Iterator<MultiBlockConnectable<T>> {
    private final Deque<MultiBlockConnectable<T>> visitQueue = new ArrayDeque<MultiBlockConnectable<T>>();

    public MultiBlockIterator(MultiBlockConnectable<T> initial) {
        this.visitQueue.offer(initial);
    }

    @Override
    public boolean hasNext() {
        return !this.visitQueue.isEmpty();
    }

    @Override
    public MultiBlockConnectable<T> next() {
        MultiBlockConnectable<T> connectable = this.visitQueue.pop();
        for (EnumFacing dir : connectable.getEmittingDirs()) {
            MultiBlockConnectable<T> adjacent = connectable.getAdjacent(dir);
            if (adjacent == null) continue;
            this.visitQueue.offer(adjacent);
        }
        return connectable;
    }
}

