/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.client.gui.component.impl;

import io.github.phantamanta44.libnine.client.gui.component.GuiComponent;
import io.github.phantamanta44.libnine.util.helper.InputUtils;
import io.github.phantamanta44.libnine.util.render.GuiUtils;
import io.github.phantamanta44.libnine.util.render.TextureRegion;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class GuiComponentTextInput
extends GuiComponent {
    private final int boxLength;
    private final int textLength;
    private final TextureRegion btnTex;
    private final TextureRegion btnTexHover;
    private final TextureRegion btnTextDisabled;
    private final int validColour;
    private final int invalidColour;
    private final Predicate<String> validator;
    private final Consumer<String> callback;
    private boolean focused;
    private boolean valid;
    private String value;
    @Nullable
    private final String tooltipKey;

    public GuiComponentTextInput(int x, int y, int boxLength, int textLength, TextureRegion btnTex, TextureRegion btnTexHover, TextureRegion btnTexDisabled, int validColour, int invalidColour, Predicate<String> validator, Consumer<String> callback, String initialValue, @Nullable String tooltipKey) {
        super(x, y, boxLength + 9 + GuiUtils.getFontHeight(), GuiUtils.getFontHeight() + 4);
        this.boxLength = boxLength;
        this.textLength = textLength;
        this.btnTex = btnTex;
        this.btnTexHover = btnTexHover;
        this.btnTextDisabled = btnTexDisabled;
        this.validColour = validColour;
        this.invalidColour = invalidColour;
        this.validator = validator;
        this.callback = callback;
        this.focused = false;
        this.value = initialValue;
        this.tooltipKey = tooltipKey;
        this.updateValidity();
    }

    public GuiComponentTextInput(int x, int y, int boxLength, int textLength, TextureRegion btnTex, TextureRegion btnTexHover, TextureRegion btnTexDisabled, int validColour, int invalidColour, Predicate<String> validator, Consumer<String> callback, String initial) {
        this(x, y, boxLength, textLength, btnTex, btnTexHover, btnTexDisabled, validColour, invalidColour, validator, callback, initial, null);
    }

    public GuiComponentTextInput(int x, int y, int boxLength, int textLength, TextureRegion btnTex, TextureRegion btnTexHover, TextureRegion btnTexDisabled, int validColour, int invalidColour, Predicate<String> validator, Consumer<String> callback) {
        this(x, y, boxLength, textLength, btnTex, btnTexHover, btnTexDisabled, validColour, invalidColour, validator, callback, "");
    }

    public void setValue(String value) {
        this.value = value.substring(0, Math.min(value.length(), this.textLength));
        this.updateValidity();
    }

    private void updateValidity() {
        this.valid = this.validator.test(this.value);
    }

    private boolean isMouseOverButton(int mX, int mY) {
        return GuiUtils.isMouseOver(this.x + this.boxLength + 5, this.y, GuiUtils.getFontHeight() + 4, GuiUtils.getFontHeight() + 4, mX, mY);
    }

    private boolean isMouseOverBox(int mX, int mY) {
        return GuiUtils.isMouseOver(this.x, this.y, this.boxLength + 4, GuiUtils.getFontHeight() + 4, mX, mY);
    }

    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public void render(float partialTicks, int mX, int mY, boolean mouseOver) {
        (this.valid ? (this.isMouseOverButton(mX, mY) ? this.btnTexHover : this.btnTex) : this.btnTextDisabled).draw(this.x + this.boxLength + 5, this.y, 13, 13);
        int colour = this.valid ? this.validColour : this.invalidColour;
        this.drawString(this.value, this.x + 2, this.y + 3, colour);
        if (this.focused && System.currentTimeMillis() % 1000L < 500L) {
            GuiUtils.drawRect(this.x + GuiUtils.getStringWidth(this.value) + 2, this.y + 2, 1, GuiUtils.getFontHeight(), colour | 0xFF000000);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void renderTooltip(float partialTicks, int mX, int mY) {
        if (this.tooltipKey != null && this.isMouseOverBox(mX, mY)) {
            this.drawTooltip(I18n.func_135052_a((String)this.tooltipKey, (Object[])new Object[0]), mX, mY);
        }
    }

    @Override
    public boolean onClick(int mX, int mY, int button, boolean mouseOver) {
        if (mouseOver) {
            if (this.isMouseOverBox(mX, mY)) {
                if (button == 1) {
                    this.value = "";
                }
                this.focused = true;
            } else {
                this.focused = false;
                if (this.isMouseOverButton(mX, mY) && this.valid) {
                    GuiComponentTextInput.playClickSound();
                    this.callback.accept(this.value);
                }
            }
            return true;
        }
        this.focused = false;
        return false;
    }

    @Override
    public boolean onKeyPress(int keyCode, char typed) {
        if (this.focused) {
            int currentLength = this.value.length();
            if (currentLength < this.textLength && typed >= ' ' && typed < '\u007f') {
                this.value = this.value + typed;
                this.updateValidity();
            } else if (keyCode == 14 && !this.value.isEmpty()) {
                if (InputUtils.checkModsNonExclusive(InputUtils.ModKey.CTRL)) {
                    int endIndex = 0;
                    if (Character.isLetterOrDigit(this.value.charAt(currentLength - 1))) {
                        for (int i = currentLength - 2; i >= 0; --i) {
                            if (Character.isLetterOrDigit(this.value.charAt(i))) continue;
                            endIndex = i;
                            break;
                        }
                    } else {
                        for (int i = currentLength - 2; i >= 0; --i) {
                            if (!Character.isLetterOrDigit(this.value.charAt(i))) continue;
                            endIndex = i;
                            break;
                        }
                    }
                    this.value = this.value.substring(0, endIndex + 1);
                } else {
                    this.value = this.value.substring(0, currentLength - 1);
                }
                this.updateValidity();
            } else if (keyCode == 28 || keyCode == 156) {
                this.updateValidity();
                if (this.valid) {
                    this.callback.accept(this.value);
                }
            } else if (keyCode == 1) {
                this.focused = false;
            }
            return true;
        }
        return false;
    }
}

