/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.baseelements;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiColourProvider;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IButtonListener;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import scala.Function0;
import scala.Unit;

public class GuiButton
extends MGuiElementBase<GuiButton> {
    protected static ResourceLocation BUTTON_TEXTURES = new ResourceLocation("textures/gui/widgets.png");
    protected ResourceLocation textureOverride;
    protected Supplier<ResourceLocation> textureSupplier;
    protected IButtonListener buttonListener = null;
    protected boolean trim = true;
    protected boolean wrap = false;
    protected boolean disabled = false;
    protected boolean dropShadow = true;
    protected GuiAlign alignment = GuiAlign.CENTER;
    protected GuiAlign.TextRotation rotation = GuiAlign.TextRotation.NORMAL;
    private double backgroundBorderWidth = 1.0;
    private String displayString = "";
    private boolean toggleMode = false;
    private boolean toggleActiveState = false;
    private boolean vanillaButtonRender = false;
    private boolean drawBorderedRectBackground = false;
    private Supplier<Boolean> toggleStateSupplier;
    private Supplier<String> displayStringSupplier;
    private Supplier<Boolean> disabledStateSupplier;
    private GuiColourProvider.HoverDisableColour<Integer> texColGetter;
    private GuiColourProvider.HoverDisableColour<Integer> rectFillColour;
    private GuiColourProvider.HoverDisableColour<Integer> rectBorderColour;
    public int buttonId = -1;
    public String buttonName = "";
    public boolean playClick = true;
    public int textXOffset = 0;
    public int textYOffset = 0;

    public GuiButton() {
        this.setInsets(5, 5, 5, 5);
    }

    public GuiButton(int xPos, int yPos) {
        super(xPos, yPos);
        this.setInsets(5, 5, 5, 5);
    }

    public GuiButton(int xPos, int yPos, int xSize, int ySize) {
        super(xPos, yPos, xSize, ySize);
        this.setInsets(5, 5, 5, 5);
    }

    public GuiButton(String buttonText) {
        this.setInsets(5, 5, 5, 5);
        this.displayString = buttonText;
    }

    public GuiButton(int xPos, int yPos, String buttonText) {
        this(xPos, yPos);
        this.displayString = buttonText;
    }

    public GuiButton(int xPos, int yPos, int xSize, int ySize, String buttonText) {
        this(xPos, yPos, xSize, ySize);
        this.displayString = buttonText;
    }

    public GuiButton(int buttonId, String buttonText) {
        this(buttonText);
        this.buttonId = buttonId;
    }

    public GuiButton(int buttonId, int xPos, int yPos, String buttonText) {
        this(xPos, yPos, buttonText);
        this.buttonId = buttonId;
    }

    public GuiButton(int buttonId, int xPos, int yPos, int xSize, int ySize, String buttonText) {
        this(xPos, yPos, xSize, ySize, buttonText);
        this.buttonId = buttonId;
    }

    public GuiButton(int buttonId) {
        this.setInsets(5, 5, 5, 5);
        this.buttonId = buttonId;
    }

    public GuiButton(int buttonId, int xPos, int yPos) {
        this(xPos, yPos);
        this.buttonId = buttonId;
    }

    public GuiButton(int buttonId, int xPos, int yPos, int xSize, int ySize) {
        this(xPos, yPos, xSize, ySize);
        this.buttonId = buttonId;
    }

    public GuiButton setListener(IButtonListener buttonListener) {
        this.buttonListener = buttonListener;
        return this;
    }

    public GuiButton setListener(Runnable action) {
        return this.setListener((GuiButton b, int m) -> action.run());
    }

    public GuiButton setListener(Function0<Unit> action) {
        return this.setListener((GuiButton b, int m) -> {
            Object unused = action.apply();
        });
    }

    public boolean isDisabled() {
        return this.disabledStateSupplier != null ? this.disabledStateSupplier.get() : this.disabled;
    }

    public GuiButton setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public GuiButton setDisabledStateSupplier(Supplier<Boolean> disabledStateSupplier) {
        this.disabledStateSupplier = disabledStateSupplier;
        return this;
    }

    public GuiButton setButtonId(int buttonId) {
        this.buttonId = buttonId;
        return this;
    }

    public GuiButton setButtonName(String buttonName) {
        this.buttonName = buttonName;
        return this;
    }

    public GuiButton setText(String displayString) {
        this.displayString = displayString;
        return this;
    }

    public GuiButton setDisplaySupplier(Supplier<String> displayStringSupplier) {
        this.displayStringSupplier = displayStringSupplier;
        return this;
    }

    public String getDisplayString() {
        return this.displayStringSupplier != null ? this.displayStringSupplier.get() : this.displayString;
    }

    public GuiButton setAlignment(GuiAlign alignment) {
        this.alignment = alignment;
        return this;
    }

    public GuiAlign getAlignment() {
        return this.alignment;
    }

    public GuiButton setTrim(boolean trim) {
        this.trim = trim;
        if (trim) {
            this.wrap = false;
        }
        return this;
    }

    public GuiButton setWrap(boolean wrap) {
        this.wrap = wrap;
        if (wrap) {
            this.trim = false;
        }
        return this;
    }

    public GuiButton setRotation(GuiAlign.TextRotation rotation) {
        this.rotation = rotation;
        return this;
    }

    public GuiAlign.TextRotation getRotation() {
        return this.rotation;
    }

    public GuiButton setShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public int getTextColour(boolean hovered, boolean disabled) {
        if (this.texColGetter != null) {
            return this.texColGetter.getColour(hovered, disabled);
        }
        if (disabled) {
            return 0xA0A0A0;
        }
        return hovered ? 0xFFFFA0 : 0xE0E0E0;
    }

    public GuiButton setTextColGetter(GuiColourProvider.HoverDisableColour<Integer> texColGetter) {
        this.texColGetter = texColGetter;
        return this;
    }

    public GuiButton setTextColour(int colour, int colourHover, int colourDisabled) {
        this.setTextColGetter((hovering, disabled1) -> disabled1 ? colourDisabled : (hovering ? colourHover : colour));
        return this;
    }

    public GuiButton setTextColour(int colour, int colourHover) {
        if (this.texColGetter != null) {
            int dis = this.texColGetter.getColour(false, true);
            this.setTextColGetter((hovering, disabled1) -> disabled1 ? dis : (hovering ? colourHover : colour));
        }
        this.setTextColGetter((hovering, disabled1) -> hovering ? colourHover : colour);
        return this;
    }

    public GuiButton setTextColour(int colour) {
        if (this.texColGetter != null) {
            int dis = this.texColGetter.getColour(false, true);
            int hover = this.texColGetter.getColour(true, false);
            this.setTextColGetter((hovering, disabled1) -> disabled1 ? dis : (hovering ? hover : colour));
        }
        this.setTextColGetter((hovering, disabled1) -> colour);
        return this;
    }

    public GuiButton setVanillaButtonRender(boolean vanillaButtonRender) {
        this.vanillaButtonRender = vanillaButtonRender;
        return this;
    }

    public GuiButton enableVanillaRender() {
        return this.setVanillaButtonRender(true);
    }

    public GuiButton disableVanillaRender() {
        return this.setVanillaButtonRender(false);
    }

    public GuiButton setDrawBorderedRectBackground(boolean drawBorderedRectBackground) {
        this.drawBorderedRectBackground = drawBorderedRectBackground;
        return this;
    }

    public GuiButton setRectFillColourGetter(GuiColourProvider.HoverDisableColour<Integer> rectBackColour) {
        this.rectFillColour = rectBackColour;
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setRectBorderColourGetter(GuiColourProvider.HoverDisableColour<Integer> rectBorderColour) {
        this.rectBorderColour = rectBorderColour;
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setRectColours(int fill, int fillHover, int fillDisabled, int border, int borderHover, int borderDisabled) {
        this.setRectFillColourGetter((hovering, disabled1) -> disabled1 ? fillDisabled : (hovering ? fillHover : fill));
        this.setRectBorderColourGetter((hovering, disabled1) -> disabled1 ? borderDisabled : (hovering ? borderHover : border));
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setRectColours(int fill, int fillHover, int border, int borderHover) {
        this.setRectFillColourGetter((hovering, disabled1) -> hovering ? fillHover : fill);
        this.setRectBorderColourGetter((hovering, disabled1) -> hovering ? borderHover : border);
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setFillColours(int fill, int fillHover, int fillDisabled) {
        this.setRectFillColourGetter((hovering, disabled1) -> disabled1 ? fillDisabled : (hovering ? fillHover : fill));
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setFillColours(int fill, int fillHover) {
        if (this.rectFillColour != null) {
            int dis = this.rectFillColour.getColour(false, true);
            this.setRectFillColourGetter((hovering, disabled1) -> disabled1 ? dis : (hovering ? fillHover : fill));
        }
        this.setRectFillColourGetter((hovering, disabled1) -> hovering ? fillHover : fill);
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setFillColour(int fill) {
        if (this.rectFillColour != null) {
            int dis = this.rectFillColour.getColour(false, true);
            int hover = this.rectFillColour.getColour(true, false);
            this.setRectFillColourGetter((hovering, disabled1) -> disabled1 ? dis : (hovering ? hover : fill));
        }
        this.setRectFillColourGetter((hovering, disabled1) -> fill);
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setBorderColours(int border, int borderHover, int borderDisabled) {
        this.setRectBorderColourGetter((hovering, disabled1) -> disabled1 ? borderDisabled : (hovering ? borderHover : border));
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setBorderColours(int border, int borderHover) {
        if (this.rectBorderColour != null) {
            int dis = this.rectBorderColour.getColour(false, true);
            this.setRectBorderColourGetter((hovering, disabled1) -> disabled1 ? dis : (hovering ? borderHover : border));
        }
        this.setRectBorderColourGetter((hovering, disabled1) -> hovering ? borderHover : border);
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setBorderColour(int border) {
        if (this.rectBorderColour != null) {
            int dis = this.rectBorderColour.getColour(false, true);
            int hover = this.rectBorderColour.getColour(true, false);
            this.setRectBorderColourGetter((hovering, disabled1) -> disabled1 ? dis : (hovering ? hover : border));
        }
        this.setRectBorderColourGetter((hovering, disabled1) -> border);
        this.setDrawBorderedRectBackground(true);
        return this;
    }

    public GuiButton setBorderWidth(double backgroundBorderWidth) {
        this.backgroundBorderWidth = backgroundBorderWidth;
        return this;
    }

    public int getFillColour(boolean hover, boolean disabled) {
        if (this.rectFillColour != null) {
            return this.rectFillColour.getColour(hover, disabled);
        }
        if (this.rectBorderColour != null) {
            return this.rectBorderColour.getColour(hover, disabled);
        }
        return 0;
    }

    public int getBorderColour(boolean hover, boolean disabled) {
        if (this.rectBorderColour != null) {
            return this.rectBorderColour.getColour(hover, disabled);
        }
        if (this.rectFillColour != null) {
            return this.rectFillColour.getColour(hover, disabled);
        }
        return 0;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.isMouseOver(mouseX, mouseY) && !this.isDisabled()) {
            this.onPressed(mouseX, mouseY, mouseButton);
            return true;
        }
        return false;
    }

    public void onPressed(int mouseX, int mouseY, int mouseButton) {
        if (this.toggleMode) {
            boolean bl = this.toggleActiveState = !this.getToggleState();
        }
        if (this.playClick) {
            this.playClickSound();
        }
        if (this.buttonListener != null) {
            this.buttonListener.onClick(this, mouseButton);
        }
    }

    public void playClickSound() {
        this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)(!this.toggleMode || this.toggleActiveState ? 1.0f : 0.9f)));
    }

    public static void playGenericClick(Minecraft mc) {
        mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public GuiButton setClickEnabled(boolean playClick) {
        this.playClick = playClick;
        return this;
    }

    public GuiButton setToggleMode(boolean toggleMode) {
        this.toggleMode = toggleMode;
        return this;
    }

    public GuiButton setToggleState(boolean toggleState) {
        this.toggleActiveState = toggleState;
        return this;
    }

    public boolean getToggleMode() {
        return this.toggleMode;
    }

    public GuiButton setToggleStateSupplier(Supplier<Boolean> toggleStateSupplier) {
        this.toggleStateSupplier = toggleStateSupplier;
        return this;
    }

    public boolean getToggleState() {
        return this.toggleStateSupplier != null ? this.toggleStateSupplier.get() : this.toggleActiveState;
    }

    protected int getRenderState(boolean hovered) {
        int i = 1;
        if (this.isDisabled()) {
            i = 0;
        } else if (hovered) {
            i = 2;
        }
        return i;
    }

    @Override
    public void renderElement(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        boolean mouseOver = this.isMouseOver(mouseX, mouseY);
        if (this.drawBorderedRectBackground) {
            this.drawBorderedRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), this.backgroundBorderWidth, this.getFillColour(mouseOver || this.toggleMode && this.getToggleState(), this.isDisabled()), this.getBorderColour(mouseOver || this.toggleMode && this.getToggleState(), this.disabled));
        }
        if (this.vanillaButtonRender) {
            this.renderVanillaButton(mc, mouseX, mouseY);
        }
        super.renderElement(mc, mouseX, mouseY, partialTicks);
        String displayString = this.getDisplayString();
        if (!displayString.isEmpty()) {
            int colour = this.getTextColour(mouseOver, this.isDisabled());
            int widthLimit = this.rotation == GuiAlign.TextRotation.NORMAL || this.rotation == GuiAlign.TextRotation.ROT_180 ? this.getInsetRect().width : this.getInsetRect().height;
            int ySize = this.fontRenderer.field_78288_b;
            if (this.wrap && !this.trim) {
                ySize = this.fontRenderer.func_78267_b(displayString, widthLimit);
            }
            boolean wrap = this.wrap && this.fontRenderer.func_78256_a(displayString) > widthLimit;
            int xPos = this.textXOffset + this.getInsetRect().x;
            int yPos = this.textYOffset + (this.getInsetRect().y + this.getInsetRect().height / 2 - ySize / 2);
            switch (this.rotation) {
                case NORMAL: {
                    this.drawCustomString(this.fontRenderer, displayString, xPos, yPos, widthLimit, colour, this.getAlignment(), this.getRotation(), wrap, this.trim, this.dropShadow);
                    break;
                }
                case ROT_CC: {
                    xPos = this.textXOffset + (this.getInsetRect().x + this.getInsetRect().width / 2 - ySize / 2);
                    yPos = this.textYOffset + this.getInsetRect().y;
                    this.drawCustomString(this.fontRenderer, displayString, xPos, yPos, widthLimit, colour, this.getAlignment(), this.getRotation(), wrap, this.trim, this.dropShadow);
                    break;
                }
                case ROT_C: {
                    xPos = this.textXOffset + (this.getInsetRect().x + this.getInsetRect().width / 2 - ySize / 2);
                    yPos = this.textYOffset + this.getInsetRect().y;
                    this.drawCustomString(this.fontRenderer, displayString, xPos + ySize, yPos, widthLimit, colour, this.getAlignment(), this.getRotation(), wrap, this.trim, this.dropShadow);
                    break;
                }
                case ROT_180: {
                    this.drawCustomString(this.fontRenderer, displayString, xPos, yPos, widthLimit, colour, this.getAlignment(), this.getRotation(), wrap, this.trim, this.dropShadow);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void renderVanillaButton(Minecraft mc, int mouseX, int mouseY) {
        this.bindTexture(this.textureSupplier != null ? this.textureSupplier.get() : (this.textureOverride != null ? this.textureOverride : BUTTON_TEXTURES));
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean hovered = this.isMouseOver(mouseX, mouseY) || this.toggleMode && this.getToggleState();
        int texVIndex = this.getRenderState(hovered);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int texHeight = Math.min(20, this.ySize());
        int texPos = 46 + texVIndex * 20;
        this.drawTexturedModalRect(this.xPos(), this.yPos(), 0, texPos, this.xSize() % 2 + this.xSize() / 2, texHeight);
        this.drawTexturedModalRect(this.xSize() % 2 + this.xPos() + this.xSize() / 2, this.yPos(), 200 - this.xSize() / 2, texPos, this.xSize() / 2, texHeight);
        if (this.ySize() < 20) {
            this.drawTexturedModalRect(this.xPos(), this.yPos() + 3, 0, texPos + 20 - this.ySize() + 3, this.xSize() % 2 + this.xSize() / 2, this.ySize() - 3);
            this.drawTexturedModalRect(this.xSize() % 2 + this.xPos() + this.xSize() / 2, this.yPos() + 3, 200 - this.xSize() / 2, texPos + 20 - this.ySize() + 3, this.xSize() / 2, this.ySize() - 3);
        } else if (this.ySize() > 20) {
            int y = this.yPos() + 17;
            while (y + 15 < this.yPos() + this.ySize()) {
                this.drawTexturedModalRect(this.xPos(), y, 0, texPos + 2, this.xSize() % 2 + this.xSize() / 2, 15);
                this.drawTexturedModalRect(this.xSize() % 2 + this.xPos() + this.xSize() / 2, y, 200 - this.xSize() / 2, texPos + 2, this.xSize() / 2, 15);
                y += 15;
            }
            this.drawTexturedModalRect(this.xPos(), this.yPos() + this.ySize() - 15, 0, texPos + 5, this.xSize() % 2 + this.xSize() / 2, 15);
            this.drawTexturedModalRect(this.xSize() % 2 + this.xPos() + this.xSize() / 2, this.yPos() + this.ySize() - 15, 200 - this.xSize() / 2, texPos + 5, this.xSize() / 2, 15);
        }
    }

    public void setTextureOverride(ResourceLocation textureOverride) {
        this.textureOverride = textureOverride;
    }

    public void setTextureSupplier(Supplier<ResourceLocation> textureSupplier) {
        this.textureSupplier = textureSupplier;
    }
}

