/*
 * Decompiled with CFR 0.152.
 */
package jobicade.hotswap;

import jobicade.hotswap.RegisterOrderKeyBinding;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;

public class ModifierKeyBinding
extends RegisterOrderKeyBinding {
    private final String suffixKey;

    public ModifierKeyBinding(String description, int keyCode, String category, String suffixKey) {
        super(description, new ModifierConflictContext(suffixKey), keyCode, category);
        this.suffixKey = suffixKey;
    }

    public ModifierKeyBinding(String description, KeyModifier keyModifier, int keyCode, String category, String suffixKey) {
        super(description, new ModifierConflictContext(suffixKey), keyModifier, keyCode, category);
        this.suffixKey = suffixKey;
    }

    public boolean overrides(KeyBinding other) {
        return this.getKeyModifier() != KeyModifier.NONE && other.getKeyModifier() == KeyModifier.NONE;
    }

    public boolean func_151470_d() {
        KeyModifier modifier = this.getModifier();
        if (modifier != null) {
            return this.getKeyConflictContext().isActive() && this.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.IN_GAME) && modifier.isActive((IKeyConflictContext)KeyConflictContext.IN_GAME);
        }
        return super.func_151470_d();
    }

    public String getDisplayName() {
        KeyModifier modifier = this.getModifier();
        if (modifier != null) {
            String tail = this.getLocalizedComboName(modifier, I18n.func_135052_a((String)this.suffixKey, (Object[])new Object[0]));
            return this.getLocalizedComboName(this.getKeyModifier(), tail);
        }
        if (this.func_151463_i() == 0) {
            return super.getDisplayName();
        }
        return I18n.func_135052_a((String)"hotswap.plus", (Object[])new Object[]{super.getDisplayName(), I18n.func_135052_a((String)this.suffixKey, (Object[])new Object[0])});
    }

    private KeyModifier getModifier() {
        for (KeyModifier modifier : KeyModifier.MODIFIER_VALUES) {
            if (!modifier.matches(this.func_151463_i())) continue;
            return modifier;
        }
        return null;
    }

    private String getLocalizedComboName(KeyModifier modifier, String tail) {
        switch (modifier) {
            case CONTROL: {
                String localizationFormatKey = Minecraft.field_142025_a ? "forge.controlsgui.control.mac" : "forge.controlsgui.control";
                return I18n.func_135052_a((String)localizationFormatKey, (Object[])new Object[]{tail});
            }
            case SHIFT: {
                return I18n.func_135052_a((String)"forge.controlsgui.shift", (Object[])new Object[]{tail});
            }
            case ALT: {
                return I18n.func_135052_a((String)"forge.controlsgui.alt", (Object[])new Object[]{tail});
            }
        }
        return tail;
    }

    private static class ModifierConflictContext
    implements IKeyConflictContext {
        private final String suffixKey;

        public ModifierConflictContext(String suffixKey) {
            this.suffixKey = suffixKey;
        }

        public boolean isActive() {
            return KeyConflictContext.IN_GAME.isActive();
        }

        public boolean conflicts(IKeyConflictContext other) {
            return other instanceof ModifierConflictContext && ((ModifierConflictContext)other).suffixKey.equals(this.suffixKey);
        }
    }
}

