/*
 * Decompiled with CFR 0.152.
 */
package jobicade.hotswap;

import invtweaks.InvTweaks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class InvTweaksSuppressor {
    private boolean enablePending;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.enablePending) {
            this.setAutoRefill(true);
            this.enablePending = false;
        }
    }

    public void suppressInvTweaks() {
        if (this.getAutoRefill()) {
            this.setAutoRefill(false);
            this.enablePending = true;
        }
    }

    private boolean getAutoRefill() {
        return "true".equals(InvTweaks.getConfigManager().getConfig().getProperty("enableAutoRefill"));
    }

    private void setAutoRefill(boolean enabled) {
        InvTweaks.getConfigManager().getConfig().setProperty("enableAutoRefill", enabled ? "true" : "false");
    }
}

