/*
 * Decompiled with CFR 0.152.
 */
package jobicade.hotswap;

import java.util.Collections;
import jobicade.hotswap.CommonProxy;
import jobicade.hotswap.RotateMessage;
import jobicade.hotswap.StepList;
import jobicade.hotswap.SwapMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="hotswap", name="HotSwap", version="0.3.2", acceptedMinecraftVersions="[1.11,1.13)", acceptableRemoteVersions="*")
public class HotSwap {
    public static final String MODID = "hotswap";
    public static final SimpleNetworkWrapper NET_WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("hotswap");
    @SidedProxy(clientSide="jobicade.hotswap.ClientProxy", serverSide="jobicade.hotswap.CommonProxy")
    private static CommonProxy proxy;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NET_WRAPPER.registerMessage(HotSwap::onRotateServer, RotateMessage.class, 0, Side.SERVER);
        NET_WRAPPER.registerMessage(HotSwap::onSwapServer, SwapMessage.class, 1, Side.SERVER);
        proxy.init();
    }

    public static void rotate(int rows, boolean wholeRow) {
        proxy.rotate(rows, wholeRow);
    }

    private static IMessage onRotateServer(RotateMessage message, MessageContext context) {
        if (message.isValid()) {
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            HotSwap.rotateLocal((EntityPlayer)player, message.getNumRows(), message.isWholeRow());
        }
        return null;
    }

    public static boolean rotateLocal(EntityPlayer player, int rows, boolean wholeRow) {
        if (!player.func_175149_v()) {
            if (wholeRow) {
                Collections.rotate(player.field_71071_by.field_70462_a, rows * 9);
                for (int i = 0; i < 9; ++i) {
                    player.field_71071_by.func_70301_a(i).func_190915_d(5);
                }
            } else {
                Collections.rotate(new StepList(player.field_71071_by.field_70462_a, player.field_71071_by.field_70461_c, 9), rows);
                player.field_71071_by.func_70448_g().func_190915_d(5);
            }
            return true;
        }
        return false;
    }

    public static void swap(int slot) {
        proxy.swap(slot);
    }

    private static IMessage onSwapServer(SwapMessage message, MessageContext context) {
        if (message.isValid()) {
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            HotSwap.swapLocal((EntityPlayer)player, message.getSlot());
        }
        return null;
    }

    public static boolean swapLocal(EntityPlayer player, int slot) {
        if (!player.func_175149_v() && slot != player.field_71071_by.field_70461_c) {
            Collections.swap(player.field_71071_by.field_70462_a, player.field_71071_by.field_70461_c, slot);
            ((ItemStack)player.field_71071_by.field_70462_a.get(player.field_71071_by.field_70461_c)).func_190915_d(5);
            ((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190915_d(5);
            return true;
        }
        return false;
    }
}

