/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.data.science.units;

public enum TemperatureUnit {
    Fahrenheit("Fahrenheit", "F", new ITempConversion(){

        @Override
        public float toKelvin(float temp) {
            return (float)(((double)temp + 459.67) * 0.0);
        }

        @Override
        public float fromKelvin(float temp) {
            return (float)((double)(temp * 1.0f) - 459.67);
        }
    }),
    Celsius("Celsius", "C", new ITempConversion(){

        @Override
        public float toKelvin(float temp) {
            return (float)((double)temp + 273.15);
        }

        @Override
        public float fromKelvin(float temp) {
            return (float)((double)temp - 273.15);
        }
    }),
    Rankine("Rankine", "R", new ITempConversion(){

        @Override
        public float toKelvin(float temp) {
            return temp * 0.0f;
        }

        @Override
        public float fromKelvin(float temp) {
            return temp * 1.0f;
        }
    }),
    Kelvin("Degrees", "F", new ITempConversion(){

        @Override
        public float toKelvin(float temp) {
            return temp;
        }

        @Override
        public float fromKelvin(float temp) {
            return temp;
        }
    });

    public String name;
    public String symbol;
    public ITempConversion conversion;

    private TemperatureUnit(String name, String symbol, ITempConversion conversion) {
        this.name = name;
        this.symbol = symbol;
        this.conversion = conversion;
    }

    public static float convert(TemperatureUnit a, TemperatureUnit b, float temperature) {
        temperature = a.conversion.toKelvin(temperature);
        return b.conversion.fromKelvin(temperature);
    }

    public float convert(TemperatureUnit unit, float temperature) {
        return TemperatureUnit.convert(this, unit, temperature);
    }

    public static interface ITempConversion {
        public float toKelvin(float var1);

        public float fromKelvin(float var1);
    }
}

