/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.proxy.jei.boiler;

import com.builtbroken.atomic.content.recipes.chem.RecipeChemBoiler;
import com.google.common.collect.Lists;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeWrapperBoiler
implements IRecipeWrapper {
    public final RecipeChemBoiler recipe;

    public RecipeWrapperBoiler(RecipeChemBoiler recipe) {
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        List<ItemStack> outputs;
        List<ItemStack> inputs = this.recipe.getPossibleInputs();
        if (inputs != null) {
            ingredients.setInputs(VanillaTypes.ITEM, inputs);
        }
        if ((outputs = this.recipe.getPossibleOutputs()) != null) {
            ingredients.setOutputs(VanillaTypes.ITEM, outputs);
        }
        if (this.recipe.inputTankBlue != null) {
            ingredients.setInput(VanillaTypes.FLUID, (Object)this.recipe.inputTankBlue);
        }
        if (this.recipe.outputTankGreen != null && this.recipe.outputTankYellow != null) {
            ingredients.setOutputs(VanillaTypes.FLUID, (List)Lists.newArrayList((Object[])new FluidStack[]{this.recipe.outputTankGreen, this.recipe.outputTankYellow}));
        } else if (this.recipe.outputTankGreen != null) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)this.recipe.outputTankGreen);
        } else if (this.recipe.outputTankYellow != null) {
            ingredients.setOutput(VanillaTypes.FLUID, (Object)this.recipe.outputTankYellow);
        }
    }
}

