/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.proxy.jei;

import com.builtbroken.atomic.content.ASItems;
import com.builtbroken.atomic.content.machines.processing.ProcessorRecipeHandler;
import com.builtbroken.atomic.content.machines.processing.boiler.gui.GuiChemBoiler;
import com.builtbroken.atomic.content.machines.processing.centrifuge.gui.GuiChemCentrifuge;
import com.builtbroken.atomic.content.machines.processing.extractor.gui.GuiChemExtractor;
import com.builtbroken.atomic.content.recipes.chem.RecipeChemBoiler;
import com.builtbroken.atomic.content.recipes.chem.RecipeChemCentrifuge;
import com.builtbroken.atomic.content.recipes.chem.RecipeChemExtractor;
import com.builtbroken.atomic.proxy.jei.boiler.RecipeCategoryBoiler;
import com.builtbroken.atomic.proxy.jei.boiler.RecipeWrapperBoiler;
import com.builtbroken.atomic.proxy.jei.centrifuge.RecipeCategoryCentrifuge;
import com.builtbroken.atomic.proxy.jei.centrifuge.RecipeWrapperCentrifuge;
import com.builtbroken.atomic.proxy.jei.extractor.RecipeCategoryExtractor;
import com.builtbroken.atomic.proxy.jei.extractor.RecipeWrapperExtractor;
import com.builtbroken.atomic.proxy.jei.grid.RecipeWrapperHazmatDye;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;

@JEIPlugin
public class JeiProxy
implements IModPlugin {
    private static final String[] dyeOredicts = new String[]{"dyeWhite", "dyeOrange", "dyeMagenta", "dyeLightBlue", "dyeYellow", "dyeLime", "dyePink", "dyeGray", "dyeLightGray", "dyeCyan", "dyePurple", "dyeBlue", "dyeBrown", "dyeGreen", "dyeRed", "dyeBlack"};

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new RecipeCategoryBoiler(registry.getJeiHelpers())});
        registry.addRecipeCategories(new IRecipeCategory[]{new RecipeCategoryExtractor(registry.getJeiHelpers())});
        registry.addRecipeCategories(new IRecipeCategory[]{new RecipeCategoryCentrifuge(registry.getJeiHelpers())});
    }

    public void register(IModRegistry registry) {
        registry.addRecipes(ProcessorRecipeHandler.INSTANCE.chemBoilerProcessingRecipe.recipes, "atomicscience:chem.boiler");
        registry.addRecipes(ProcessorRecipeHandler.INSTANCE.chemExtractorProcessingRecipe.recipes, "atomicscience:chem.extractor");
        registry.addRecipes(ProcessorRecipeHandler.INSTANCE.chemCentrifugeProcessingRecipe.recipes, "atomicscience:chem.centrifuge");
        ArrayList<RecipeWrapperHazmatDye> dyeArmor = new ArrayList<RecipeWrapperHazmatDye>(dyeOredicts.length);
        for (String dyeName : dyeOredicts) {
            dyeArmor.add(new RecipeWrapperHazmatDye(dyeName, ASItems.itemArmorHazmatHelmColor));
            dyeArmor.add(new RecipeWrapperHazmatDye(dyeName, ASItems.itemArmorHazmatChestColor));
            dyeArmor.add(new RecipeWrapperHazmatDye(dyeName, ASItems.itemArmorHazmatLegsColor));
            dyeArmor.add(new RecipeWrapperHazmatDye(dyeName, ASItems.itemArmorHazmatBootsColor));
        }
        registry.addRecipes(dyeArmor, "minecraft.crafting");
        registry.handleRecipes(RecipeChemBoiler.class, recipe -> new RecipeWrapperBoiler((RecipeChemBoiler)recipe), "atomicscience:chem.boiler");
        registry.handleRecipes(RecipeChemExtractor.class, recipe -> new RecipeWrapperExtractor((RecipeChemExtractor)recipe), "atomicscience:chem.extractor");
        registry.handleRecipes(RecipeChemCentrifuge.class, recipe -> new RecipeWrapperCentrifuge((RecipeChemCentrifuge)recipe), "atomicscience:chem.centrifuge");
        registry.addRecipeClickArea(GuiChemBoiler.class, 73, 30, 22, 15, new String[]{"atomicscience:chem.boiler"});
        registry.addRecipeClickArea(GuiChemExtractor.class, 73, 30, 22, 15, new String[]{"atomicscience:chem.extractor"});
        registry.addRecipeClickArea(GuiChemCentrifuge.class, 73, 30, 22, 15, new String[]{"atomicscience:chem.centrifuge"});
    }
}

