/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.proxy.eu;

import com.builtbroken.atomic.config.mods.ConfigMod;
import com.builtbroken.atomic.lib.power.PowerHandler;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PowerHandlerEU
extends PowerHandler {
    public static final PowerHandlerEU INSTANCE = new PowerHandlerEU();

    @Override
    @Optional.Method(modid="ic2")
    public boolean canHandle(ItemStack stack) {
        return ConfigMod.IC2.ENABLE_POWER && stack.func_77973_b() instanceof IElectricItem;
    }

    @Override
    @Optional.Method(modid="ic2")
    public boolean canHandle(EnumFacing side, TileEntity tile) {
        return ConfigMod.IC2.ENABLE_POWER && tile instanceof IEnergySink && ((IEnergySink)tile).acceptsEnergyFrom(null, side);
    }

    @Override
    @Optional.Method(modid="ic2")
    public int addPower(EnumFacing side, TileEntity tile, int powerInFE, boolean doAction) {
        if (this.canHandle(side, tile)) {
            double demand_eu = ((IEnergySink)tile).getDemandedEnergy();
            int demand_fe = (int)Math.floor(demand_eu * ConfigMod.IC2.FE_PER_EU);
            if (!doAction) {
                return demand_fe;
            }
            int inject_fe = Math.min(demand_fe, powerInFE);
            if (inject_fe > 0) {
                double inject_eu = (double)inject_fe / ConfigMod.IC2.FE_PER_EU;
                double remain_eu = ((IEnergySink)tile).injectEnergy(side, inject_eu, 1.0);
                return (int)Math.ceil((inject_eu -= remain_eu) * ConfigMod.IC2.FE_PER_EU);
            }
        }
        return 0;
    }

    @Override
    @Optional.Method(modid="ic2")
    public int chargeItem(ItemStack stack, int insert_fe, boolean doAction) {
        if (this.canHandle(stack)) {
            int tier = ((IElectricItem)stack.func_77973_b()).getTier(stack);
            double insert_eu = (double)insert_fe / ConfigMod.IC2.FE_PER_EU;
            double taken_eu = ElectricItem.manager.charge(stack, insert_eu, tier, false, !doAction);
            return (int)Math.ceil(taken_eu * ConfigMod.IC2.FE_PER_EU);
        }
        return 0;
    }

    @Override
    @Optional.Method(modid="ic2")
    public int dischargeItem(ItemStack stack, int remove_fe, boolean doAction) {
        if (this.canHandle(stack)) {
            int tier = ((IElectricItem)stack.func_77973_b()).getTier(stack);
            double remove_eu = (double)remove_fe / ConfigMod.IC2.FE_PER_EU;
            remove_eu = ElectricItem.manager.discharge(stack, remove_eu, tier, false, true, !doAction);
            return (int)Math.ceil(remove_eu * ConfigMod.IC2.FE_PER_EU);
        }
        return 0;
    }

    @Override
    @Optional.Method(modid="ic2")
    public int getItemPower(ItemStack stack) {
        if (this.canHandle(stack)) {
            return (int)Math.floor(ElectricItem.manager.getCharge(stack) * ConfigMod.IC2.FE_PER_EU);
        }
        return 0;
    }

    @Override
    @Optional.Method(modid="ic2")
    public int getItemMaxPower(ItemStack stack) {
        if (this.canHandle(stack)) {
            return (int)Math.floor(ElectricItem.manager.getMaxCharge(stack) * ConfigMod.IC2.FE_PER_EU);
        }
        return 0;
    }

    @Override
    @Optional.Method(modid="ic2")
    public void onTileValidate(TileEntity tile) {
        if (ConfigMod.IC2.ENABLE_POWER && tile instanceof IEnergyTile && !tile.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)tile));
        }
    }

    @Override
    @Optional.Method(modid="ic2")
    public void onTileInvalidate(TileEntity tile) {
        if (ConfigMod.IC2.ENABLE_POWER && tile instanceof IEnergyTile && !tile.func_145831_w().field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)tile));
        }
    }
}

