/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.proxy.bc;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjPassiveProvider;
import buildcraft.api.mj.IMjReceiver;
import com.builtbroken.atomic.config.mods.ConfigMod;
import com.builtbroken.atomic.proxy.bc.PowerHandlerMJ;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class MjEnergyWrapper
implements IMjReceiver,
IMjPassiveProvider {
    private final TileEntity tile;
    private final EnumFacing side;

    public MjEnergyWrapper(TileEntity tile, EnumFacing side) {
        this.tile = tile;
        this.side = side;
    }

    public long getPowerRequested() {
        IEnergyStorage energyStorage;
        if (ConfigMod.BUILDCRAFT.ENABLE_BUILDCRAFT && (energyStorage = (IEnergyStorage)this.tile.getCapability(CapabilityEnergy.ENERGY, this.side)) != null) {
            int energyNeeded = energyStorage.receiveEnergy(Integer.MAX_VALUE, true);
            return (long)Math.floor(PowerHandlerMJ.toBuildcraftEnergy(energyNeeded));
        }
        return 0L;
    }

    public long receivePower(long microJoules, boolean simulate) {
        IEnergyStorage energyStorage;
        if (ConfigMod.BUILDCRAFT.ENABLE_BUILDCRAFT && (energyStorage = (IEnergyStorage)this.tile.getCapability(CapabilityEnergy.ENERGY, this.side)) != null && energyStorage.canReceive()) {
            int energy = (int)Math.floor(PowerHandlerMJ.toForgeEnergy(microJoules));
            int taken = energyStorage.receiveEnergy(energy, simulate);
            long taken_mj = (long)Math.ceil(PowerHandlerMJ.toBuildcraftEnergy(taken));
            return microJoules - taken_mj;
        }
        return microJoules;
    }

    public boolean canConnect(@Nonnull IMjConnector other) {
        return ConfigMod.BUILDCRAFT.ENABLE_BUILDCRAFT;
    }

    public long extractPower(long min, long max, boolean simulate) {
        IEnergyStorage energyStorage;
        if (ConfigMod.BUILDCRAFT.ENABLE_BUILDCRAFT && (energyStorage = (IEnergyStorage)this.tile.getCapability(CapabilityEnergy.ENERGY, this.side)) != null && energyStorage.canExtract()) {
            int fe = (int)Math.floor(PowerHandlerMJ.toForgeEnergy(max));
            long energy = (long)Math.floor(PowerHandlerMJ.toBuildcraftEnergy(fe = energyStorage.extractEnergy(fe, true)));
            if (energy > min) {
                energy = Math.min(energy, max);
                if (!simulate) {
                    fe = (int)Math.ceil(PowerHandlerMJ.toForgeEnergy(energy));
                    energyStorage.extractEnergy(fe, false);
                }
                return fe;
            }
        }
        return 0L;
    }
}

