/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.proxy.bc;

import buildcraft.api.mj.MjAPI;
import com.builtbroken.atomic.config.mods.ConfigMod;
import com.builtbroken.atomic.proxy.bc.MjEnergyWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MjCapabilityProvider
implements ICapabilityProvider {
    private final TileEntity tile;
    private final MjEnergyWrapper[] wrappers = new MjEnergyWrapper[6];

    public MjCapabilityProvider(TileEntity tile) {
        this.tile = tile;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (ConfigMod.BUILDCRAFT.ENABLE_BUILDCRAFT) {
            return capability == MjAPI.CAP_RECEIVER || capability == MjAPI.CAP_CONNECTOR || capability == MjAPI.CAP_PASSIVE_PROVIDER;
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            if (this.wrappers[facing.ordinal()] == null) {
                this.wrappers[facing.ordinal()] = new MjEnergyWrapper(this.tile, facing);
            }
            return (T)this.wrappers[facing.ordinal()];
        }
        return null;
    }
}

