/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.network.packet.client;

import com.builtbroken.atomic.CommonProxy;
import com.builtbroken.atomic.content.machines.accelerator.particle.AcceleratorParticle;
import com.builtbroken.atomic.network.IPacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketAcceleratorParticleSync
implements IPacket {
    public UUID ID;
    public int dim;
    public float cx;
    public float cy;
    public float cz;
    public float speed;
    public ItemStack renderItem = ItemStack.field_190927_a;

    public PacketAcceleratorParticleSync() {
    }

    public PacketAcceleratorParticleSync(AcceleratorParticle particle) {
        this.ID = particle.unique_id;
        this.dim = particle.dim();
        this.cx = particle.xf();
        this.cy = particle.yf();
        this.cz = particle.zf();
        this.speed = particle.getVelocity();
        this.renderItem = particle.getItem();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeLong(this.ID.getMostSignificantBits());
        buffer.writeLong(this.ID.getLeastSignificantBits());
        buffer.writeInt(this.dim);
        buffer.writeFloat(this.cx);
        buffer.writeFloat(this.cy);
        buffer.writeFloat(this.cz);
        buffer.writeFloat(this.speed);
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.renderItem);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.ID = new UUID(buffer.readLong(), buffer.readLong());
        this.dim = buffer.readInt();
        this.cx = buffer.readFloat();
        this.cy = buffer.readFloat();
        this.cz = buffer.readFloat();
        this.speed = buffer.readFloat();
        this.renderItem = ByteBufUtils.readItemStack((ByteBuf)buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        CommonProxy.NEW_PARTICLE_PACKETS.add(this);
    }
}

