/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.network.packet;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.lib.transform.vector.Location;
import com.builtbroken.atomic.network.IPacketIDReceiver;
import com.builtbroken.atomic.network.ex.PacketTileReadException;
import com.builtbroken.atomic.network.packet.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketTile
extends PacketBase {
    public int dim;
    public BlockPos pos;
    public int id;
    public String name;

    public PacketTile() {
    }

    public PacketTile(String name, int id, int dim, BlockPos pos) {
        this.dim = dim;
        this.name = name;
        this.id = id;
        this.pos = pos;
    }

    public PacketTile(String name, int id, TileEntity tile) {
        this(name, id, tile.func_145831_w().field_73011_w.getDimension(), tile.func_174877_v());
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeBoolean(AtomicScience.runningAsDev);
        if (AtomicScience.runningAsDev) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.name);
        }
        buffer.writeInt(this.id);
        buffer.writeInt(this.dim);
        buffer.writeInt(this.pos.func_177958_n());
        buffer.writeInt(this.pos.func_177956_o());
        buffer.writeInt(this.pos.func_177952_p());
        super.encodeInto(ctx, buffer);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.name = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
        this.id = buffer.readInt();
        this.dim = buffer.readInt();
        this.pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        super.decodeInto(ctx, buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        if (player != null) {
            this.handle(player);
        } else if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("PacketTile#handleClientSide(null) - player was null for packet", (Throwable)new RuntimeException());
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        if (player != null) {
            this.handle(player);
        } else if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("PacketTile#handleServerSide(null) - player was null for packet", (Throwable)new RuntimeException());
        }
    }

    public void handle(EntityPlayer player) {
        if (player.func_130014_f_() == null) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("PacketTile#handle(" + player + ", " + this.name + ") - world is null for player while handling packet. ", (Throwable)new RuntimeException());
            }
        } else if (player.func_130014_f_().field_73011_w.getDimension() != this.dim) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("PacketTile#handle(" + player + ", " + this.name + ") - packet received on wrong dim. Current[" + player.func_130014_f_().field_73011_w.getDimension() + "] Expected[" + this.dim + "]");
            }
        } else if (player.func_130014_f_().func_175668_a(this.pos, false)) {
            this.handle(player, player.func_130014_f_().func_175625_s(this.pos));
        } else if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("PacketTile#handle(" + player + ", " + this.name + ") - block at " + this.pos + " is not loaded for player while handling packet. ");
        }
    }

    public void handle(EntityPlayer player, TileEntity tile) {
        Location location = new Location(player.field_70170_p, this.pos);
        if (tile == null) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error((Object)new PacketTileReadException(location, "Null tile, PacketName: " + this.name));
            }
        } else if (tile.func_145837_r()) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error((Object)new PacketTileReadException(location, "Invalidated tile, PacketName: " + this.name));
            }
        } else if (tile instanceof IPacketIDReceiver) {
            if (((IPacketIDReceiver)tile).shouldReadPacket(player, location, this)) {
                try {
                    IPacketIDReceiver receiver = (IPacketIDReceiver)tile;
                    receiver.read(this.dataToRead, this.id, player, this);
                }
                catch (IndexOutOfBoundsException e) {
                    AtomicScience.logger.error((Object)new PacketTileReadException(location, "Packet was read past it's size, PacketName: " + this.name));
                    AtomicScience.logger.error("Error: ", (Throwable)e);
                }
                catch (NullPointerException e) {
                    AtomicScience.logger.error((Object)new PacketTileReadException(location, "Null pointer while reading data, PacketName: " + this.name, e));
                    AtomicScience.logger.error("Error: ", (Throwable)e);
                }
                catch (Exception e) {
                    AtomicScience.logger.error((Object)new PacketTileReadException(location, "Failed to read packet, PacketName: " + this.name, e));
                    AtomicScience.logger.error("Error: ", (Throwable)e);
                }
            } else if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("Error: " + tile + " rejected packet " + this + " due to invalid conditions, PacketName: " + this.name);
            }
        } else if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error((Object)new PacketTileReadException(location, "Unsupported action for " + tile + ", PacketName: " + this.name));
        }
    }
}

