/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.thermal.thread;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.thermal.IThermalSource;
import com.builtbroken.atomic.config.server.ConfigThread;
import com.builtbroken.atomic.lib.thermal.ThermalHandler;
import com.builtbroken.atomic.map.data.DataChange;
import com.builtbroken.atomic.map.data.DataPos;
import com.builtbroken.atomic.map.data.ThreadDataChange;
import com.builtbroken.atomic.map.thermal.thread.HeatPushCallback;
import com.builtbroken.atomic.map.thermal.thread.ThermalServerTask;
import com.builtbroken.atomic.map.thermal.thread.ThermalThreadData;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.jlib.lang.StringHelpers;
import java.util.LinkedList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ThreadThermalAction
extends ThreadDataChange {
    public ThreadThermalAction() {
        super("ThreadThermalAction");
    }

    @Override
    protected boolean updateLocation(DataChange change) {
        WorldServer world = DimensionManager.getWorld((int)change.dim());
        int cx = change.xi();
        int cy = change.yi();
        int cz = change.zi();
        if (world instanceof WorldServer && change.source instanceof IThermalSource) {
            ThermalThreadData thermalThreadData = this.createData((World)world, cx, cy, cz, ConfigThread.THREAD_HEAT_PATHING_RANGE);
            this.calculateHeatSpread(thermalThreadData, change.value);
            this.completeUpdateLocation((World)world, (IThermalSource)change.source, thermalThreadData);
            return true;
        }
        return false;
    }

    protected ThermalThreadData createData(World world, int cx, int cy, int cz, int range) {
        return new ThermalThreadData(world, cx, cy, cz, range);
    }

    protected void completeUpdateLocation(World world, IThermalSource source, ThermalThreadData data) {
        ((WorldServer)world).func_152344_a((Runnable)new ThermalServerTask(source, data));
    }

    protected void calculateHeatSpread(ThermalThreadData thermalThreadData, int heatTotal) {
        long time = System.nanoTime();
        if (heatTotal > 6) {
            LinkedList<DataPos> currentPathQueue = new LinkedList<DataPos>();
            LinkedList<DataPos> normalizeQueue = new LinkedList<DataPos>();
            LinkedList nextPathQueue = new LinkedList();
            thermalThreadData.setHeat(DataPos.get(thermalThreadData), heatTotal);
            currentPathQueue.add(DataPos.get(thermalThreadData).lock());
            while (!currentPathQueue.isEmpty() || !nextPathQueue.isEmpty()) {
                DataPos pooledPos;
                DataPos nextPathPos;
                if (currentPathQueue.isEmpty()) {
                    normalizeQueue.forEach(pos -> {
                        thermalThreadData.normalize((DataPos)pos);
                        pos.unlock().dispose();
                    });
                    normalizeQueue.clear();
                    currentPathQueue.addAll(nextPathQueue);
                    nextPathQueue.clear();
                }
                if ((nextPathPos = thermalThreadData.setToPush(pooledPos = (DataPos)currentPathQueue.poll())) == null) continue;
                this.pathNext(thermalThreadData, nextPathPos, (x, y, z, heat) -> {
                    if (heat > 0) {
                        DataPos tempPos = DataPos.get(x, y, z);
                        if (!thermalThreadData.hasData(tempPos)) {
                            nextPathQueue.add(DataPos.get(x, y, z).lock());
                        }
                        thermalThreadData.addHeat(tempPos, heat);
                        tempPos.dispose();
                    }
                });
                normalizeQueue.offer(nextPathPos.lock());
            }
        }
        if (AtomicScience.runningAsDev) {
            time = System.nanoTime() - time;
            AtomicScience.logger.info(String.format("%s: Spread heat %s | %s tiles | %s %s %s | in %s", this.name, heatTotal, thermalThreadData.getData().size(), thermalThreadData.xi(), thermalThreadData.yi(), thermalThreadData.zi(), StringHelpers.formatNanoTime(time)));
        }
    }

    protected void pathNext(ThermalThreadData thermalThreadData, DataPos currentPos, HeatPushCallback heatSetter) {
        IBlockState giverBlock = thermalThreadData.world.func_180495_p(currentPos.getPos());
        int totalMovementHeat = thermalThreadData.getHeatToMove(currentPos);
        int heatLoss = ThermalHandler.getHeatLost(giverBlock, totalMovementHeat);
        BlockPos.PooledMutableBlockPos blockPos = BlockPos.PooledMutableBlockPos.func_185346_s();
        this.forEach(thermalThreadData, currentPos, (x, y, z, dir) -> {
            blockPos.func_181079_c(x, y, z);
            IBlockState targetBlock = thermalThreadData.world.func_180495_p((BlockPos)blockPos);
            int heatMoved = ThermalHandler.getHeatMoved(targetBlock, totalMovementHeat);
            heatMoved = Math.max(0, heatMoved - heatLoss);
            heatSetter.pushHeat(x, y, z, heatMoved);
        });
        blockPos.func_185344_t();
    }

    private void forEach(IPos3D center, DataPos currentPos, HeatDirConsumer directionConsumer) {
        for (EnumFacing direction : EnumFacing.values()) {
            int x = currentPos.xi() + direction.func_82601_c();
            int y = currentPos.yi() + direction.func_96559_d();
            int z = currentPos.zi() + direction.func_82599_e();
            if (!this.inRange(center, x, y, z, ConfigThread.THREAD_HEAT_PATHING_RANGE) || y < 0 || y >= 256) continue;
            directionConsumer.accept(x, y, z, direction);
        }
    }

    public static interface HeatDirConsumer {
        public void accept(int var1, int var2, int var3, EnumFacing var4);
    }
}

