/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.thermal.thread;

import com.builtbroken.atomic.lib.thermal.ThermalHandler;
import com.builtbroken.atomic.lib.transform.IPosWorld;
import com.builtbroken.atomic.map.data.DataPos;
import com.builtbroken.atomic.map.thermal.thread.ThermalData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;

public class ThermalThreadData
implements IPosWorld {
    public final World world;
    private final DataPos center;
    public final int range;
    private final HashMap<DataPos, ThermalData> heatSpreadData = new HashMap();

    public ThermalThreadData(World world, int cx, int cy, int cz, int range) {
        this.world = world;
        this.center = DataPos.get(cx, cy, cz);
        this.range = range;
    }

    public boolean hasData(DataPos pos) {
        return this.heatSpreadData.containsKey(pos);
    }

    public boolean canReceive(DataPos pos) {
        if (this.heatSpreadData.containsKey(pos)) {
            return !this.heatSpreadData.get(pos).hasPushedHeat();
        }
        return true;
    }

    public DataPos setToPush(DataPos pos) {
        if (this.heatSpreadData.containsKey(pos)) {
            this.heatSpreadData.get(pos).setToPush();
            return pos;
        }
        return null;
    }

    public int getHeatToMove(DataPos pos) {
        if (this.heatSpreadData.containsKey(pos)) {
            return this.heatSpreadData.get(pos).getHeatToPush();
        }
        return 0;
    }

    public int getHeat(DataPos currentPos) {
        if (this.heatSpreadData.containsKey(currentPos)) {
            return this.heatSpreadData.get(currentPos).getHeat();
        }
        return 0;
    }

    public void setHeat(DataPos pos, int heatAsPosition) {
        if (this.heatSpreadData.containsKey(pos)) {
            this.heatSpreadData.get(pos).setHeat(heatAsPosition);
        } else {
            this.heatSpreadData.put(DataPos.get(pos).lock(), ThermalData.get(heatAsPosition));
        }
    }

    public void addHeat(DataPos currentPos, int heatAsPosition) {
        this.setHeat(currentPos, this.getHeat(currentPos) + heatAsPosition);
    }

    public void normalize(DataPos pos) {
        int cap;
        int heat;
        if (this.heatSpreadData.containsKey(pos) && (heat = this.getHeat(pos)) > (cap = ThermalHandler.getBlockCapacity(this.world.func_180495_p(pos.getPos())))) {
            this.setHeat(pos, cap);
        }
    }

    @Override
    public int dim() {
        return this.world.field_73011_w.getDimension();
    }

    @Override
    public double z() {
        return this.center.zi();
    }

    @Override
    public double x() {
        return this.center.xi();
    }

    @Override
    public double y() {
        return this.center.yi();
    }

    @Override
    public int zi() {
        return this.center.zi();
    }

    @Override
    public int xi() {
        return this.center.xi();
    }

    @Override
    public int yi() {
        return this.center.yi();
    }

    public Map<DataPos, ThermalData> getData() {
        return this.heatSpreadData;
    }
}

