/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.thermal.thread;

import com.builtbroken.atomic.api.thermal.IThermalNode;
import com.builtbroken.atomic.api.thermal.IThermalSource;
import com.builtbroken.atomic.map.data.DataPos;
import com.builtbroken.atomic.map.thermal.node.ThermalNode;
import com.builtbroken.atomic.map.thermal.thread.ThermalData;
import com.builtbroken.atomic.map.thermal.thread.ThermalThreadData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public class ThermalServerTask
implements Runnable {
    public final IThermalSource source;
    public final ThermalThreadData thermalThreadData;

    public ThermalServerTask(IThermalSource source, ThermalThreadData thermalThreadData) {
        this.source = source;
        this.thermalThreadData = thermalThreadData;
    }

    @Override
    public void run() {
        HashMap<BlockPos, IThermalNode> oldMap = this.source.getCurrentNodes();
        HashMap<BlockPos, IThermalNode> newMap = new HashMap<BlockPos, IThermalNode>();
        this.source.disconnectMapData();
        for (Map.Entry<DataPos, ThermalData> entry : this.thermalThreadData.getData().entrySet()) {
            BlockPos pos = entry.getKey().unlock().disposeReturnBlockPos();
            int value = entry.getValue().getHeatAndDispose();
            if (oldMap != null && oldMap.containsKey(pos)) {
                IThermalNode node = oldMap.get(pos);
                if (node != null) {
                    node.setHeatValue(value);
                    newMap.put(pos, node);
                }
                oldMap.remove(pos);
                continue;
            }
            newMap.put(pos, ThermalNode.get(this.source, value));
        }
        this.source.disconnectMapData();
        this.source.clearMapData();
        this.source.setCurrentNodes(newMap);
        this.source.connectMapData();
        this.source.initMapData();
    }
}

