/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.thermal.thread;

import com.builtbroken.atomic.map.data.DataPool;

public class ThermalData {
    private static final DataPool<ThermalData> objectPool = new DataPool(100000);
    int heatToPush = -1;
    int heatValue;

    private ThermalData() {
    }

    public static ThermalData get(int heat) {
        ThermalData data;
        if (objectPool.has() && (data = objectPool.get()) != null) {
            data.heatToPush = -1;
            data.heatValue = heat;
            return data;
        }
        return new ThermalData().setHeat(heat);
    }

    public void setToPush() {
        this.heatToPush = this.heatValue;
    }

    public boolean hasPushedHeat() {
        return this.heatToPush != -1;
    }

    public int getHeatToPush() {
        return this.heatToPush;
    }

    public int getHeat() {
        return this.heatValue;
    }

    public int getHeatAndDispose() {
        int heat = this.heatValue;
        objectPool.dispose(this);
        return heat;
    }

    public ThermalData setHeat(int heat) {
        this.heatValue = heat;
        return this;
    }

    public ThermalData addHeat(int heat) {
        this.heatValue += heat;
        return this;
    }

    public void dispose() {
        objectPool.dispose(this);
    }
}

