/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.thermal.node;

import com.builtbroken.atomic.map.thermal.node.ThermalSource;
import java.lang.ref.WeakReference;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ThermalSourceTile<E extends TileEntity>
extends ThermalSource<E> {
    private final IntSupplier heatFunction;
    private final BooleanSupplier activeFunction;
    private final WeakReference<E> hostReference;

    public ThermalSourceTile(E host, IntSupplier heatFunction, BooleanSupplier activeFunction) {
        this.hostReference = new WeakReference<E>(host);
        this.heatFunction = heatFunction;
        this.activeFunction = activeFunction;
    }

    @Override
    public boolean canGeneratingHeat() {
        return this.getHeatGenerated() > 0 && this.activeFunction.getAsBoolean();
    }

    @Override
    public boolean doesSourceExist() {
        return this.world() != null && this.getHost() != null && !this.getHost().func_145837_r() && this.world().func_175625_s(this.getPos()) == this.getHost();
    }

    @Override
    public int getHeatGenerated() {
        return this.heatFunction.getAsInt();
    }

    @Override
    public World world() {
        return this.getHost().func_145831_w();
    }

    @Override
    public double z() {
        return (double)this.getHost().func_174877_v().func_177952_p() + 0.5;
    }

    @Override
    public double x() {
        return (double)this.getHost().func_174877_v().func_177958_n() + 0.5;
    }

    @Override
    public double y() {
        return (double)this.getHost().func_174877_v().func_177956_o() + 0.5;
    }

    @Override
    public int zi() {
        return this.getHost().func_174877_v().func_177952_p();
    }

    @Override
    public int xi() {
        return this.getHost().func_174877_v().func_177958_n();
    }

    @Override
    public int yi() {
        return this.getHost().func_174877_v().func_177956_o();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ThermalSourceTile) {
            if (this.getHost() != null && ((ThermalSourceTile)object).getHost() != null) {
                return this.getHost().func_145831_w() == ((ThermalSourceTile)object).getHost().func_145831_w() && this.getHost().func_174877_v() == ((ThermalSourceTile)object).getHost().func_174877_v();
            }
            return ((ThermalSourceTile)object).getHost() == this.getHost();
        }
        return false;
    }

    @Override
    protected String getDebugName() {
        return "ThermalSourceTile";
    }

    @Override
    public E getHost() {
        return (E)((TileEntity)this.hostReference.get());
    }
}

