/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.thermal.node;

import com.builtbroken.atomic.api.map.DataMapType;
import com.builtbroken.atomic.api.thermal.IThermalNode;
import com.builtbroken.atomic.api.thermal.IThermalSource;
import com.builtbroken.atomic.map.data.node.MapNodeSource;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ThermalSource<E>
extends MapNodeSource<E, IThermalNode>
implements IThermalSource {
    public static final String NBT_HEAT = "heat";

    @Override
    public boolean canGeneratingHeat() {
        return this.getHeatGenerated() > 0;
    }

    @Override
    public boolean isStillValid() {
        return super.isStillValid() && this.canGeneratingHeat();
    }

    @Override
    public DataMapType getType() {
        return DataMapType.THERMAL;
    }

    @Override
    public NBTTagCompound getSaveState() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a(NBT_HEAT, this.getHeatGenerated());
        return tagCompound;
    }

    @Override
    public boolean shouldQueueForUpdate(NBTTagCompound saveState) {
        int heat = this.getHeatGenerated();
        if (heat > 0 && !this.hasNodes()) {
            return true;
        }
        return saveState == null || saveState.func_74762_e(NBT_HEAT) != heat;
    }

    @Override
    protected String addDebugInfo() {
        return "HEAT: " + this.canGeneratingHeat() + "-" + this.getHeatGenerated() + ", ";
    }

    @Override
    protected String getDebugName() {
        return "RadiationSource";
    }
}

