/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.thermal.node;

import com.builtbroken.atomic.api.map.DataMapType;
import com.builtbroken.atomic.api.map.IDataMapSource;
import com.builtbroken.atomic.api.thermal.IThermalNode;
import com.builtbroken.atomic.api.thermal.IThermalSource;
import com.builtbroken.atomic.map.data.DataPool;
import com.builtbroken.atomic.map.data.IDataPoolObject;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;

public class ThermalNode
implements IThermalNode,
IDataPoolObject {
    private static final DataPool<ThermalNode> THERMAL_NODE_POOL = new DataPool(400000);
    private WeakReference<IThermalSource> source;
    private int value;

    private ThermalNode(IThermalSource source, int value) {
        this.source = new WeakReference<IThermalSource>(source);
        this.value = value;
    }

    @Override
    public int getHeatValue() {
        return this.value;
    }

    @Override
    public void setHeatValue(int value) {
        this.value = value;
    }

    @Override
    public DataMapType getType() {
        return DataMapType.THERMAL;
    }

    @Override
    @Nullable
    public IDataMapSource getSource() {
        if (this.source == null || this.source.get() == null) {
            return null;
        }
        return (IDataMapSource)this.source.get();
    }

    public static ThermalNode get(IThermalSource source, int value) {
        ThermalNode dataChange;
        if (THERMAL_NODE_POOL.has() && (dataChange = THERMAL_NODE_POOL.get()) != null) {
            dataChange.source = new WeakReference<IThermalSource>(source);
            dataChange.value = value;
            return dataChange;
        }
        return new ThermalNode(source, value);
    }

    @Override
    public void dispose() {
        this.source = null;
        THERMAL_NODE_POOL.dispose(this);
    }
}

