/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.thermal;

import com.builtbroken.atomic.api.map.DataMapType;
import com.builtbroken.atomic.api.thermal.IThermalSystem;
import com.builtbroken.atomic.config.server.ConfigServer;
import com.builtbroken.atomic.lib.vapor.VaporHandler;
import com.builtbroken.atomic.map.MapHandler;
import com.builtbroken.atomic.map.events.MapSystemEvent;
import com.builtbroken.atomic.network.IPacket;
import com.builtbroken.atomic.network.netty.PacketSystem;
import com.builtbroken.atomic.network.packet.client.PacketSpawnParticle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ThermalMap
implements IThermalSystem {
    private HashMap<Integer, HashSet<BlockPos>> steamSources = new HashMap();

    public int getStoredHeat(World world, BlockPos pos) {
        return DataMapType.THERMAL.getValue(MapHandler.GLOBAL_DATA_MAP.getData(world, pos));
    }

    public void onWorldUnload(World world) {
        this.steamSources.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHeatChanged(MapSystemEvent.OnValueChanged event) {
        World world = event.world();
        if (world != null && !world.field_72995_K && event.type == DataMapType.THERMAL && world.func_175667_e(event.getPos())) {
            this.checkForThermalChange(world, event.getPos(), event.getNewValue());
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K) {
            this.checkForThermalChange(event.getWorld(), event.getPos(), this.getStoredHeat(event.getWorld(), event.getPos()));
        }
    }

    protected void checkForThermalChange(World world, BlockPos pos, int heat) {
        int vap = VaporHandler.getVaporRate(world, pos, heat);
        int dim = world.field_73011_w.getDimension();
        if (!this.steamSources.containsKey(dim)) {
            this.steamSources.put(dim, new HashSet());
        }
        if (vap > 0) {
            if (!this.steamSources.get(dim).contains(pos)) {
                this.steamSources.get(dim).add(pos);
            }
        } else if (!this.steamSources.get(dim).contains(pos)) {
            this.steamSources.remove(pos);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            World world = event.world;
            int dim = world.field_73011_w.getDimension();
            if (ConfigServer.NETWORK.BOILING_EFFECT && this.steamSources.containsKey(dim)) {
                HashSet<BlockPos> steamPositions = this.steamSources.get(dim);
                Iterator<BlockPos> it = steamPositions.iterator();
                while (it.hasNext()) {
                    BlockPos pos = it.next();
                    if (world.func_175667_e(pos)) {
                        int vap = VaporHandler.getVaporRate(world, pos);
                        if (vap > 0) {
                            if (!((double)event.world.field_73012_v.nextFloat() > 0.6)) continue;
                            int count = Math.min(10, Math.max(1, vap / 100));
                            PacketSpawnParticle packetSpawnParticle = new PacketSpawnParticle(dim, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, "boiling;" + count);
                            PacketSystem.INSTANCE.sendToAllAround((IPacket)packetSpawnParticle, world, pos, 30.0);
                            continue;
                        }
                        it.remove();
                        continue;
                    }
                    it.remove();
                }
            }
        }
    }
}

