/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.exposure.thread;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.map.DataMapType;
import com.builtbroken.atomic.api.radiation.IRadiationSource;
import com.builtbroken.atomic.config.server.ConfigThread;
import com.builtbroken.atomic.lib.radiation.RadiationHandler;
import com.builtbroken.atomic.map.data.DataChange;
import com.builtbroken.atomic.map.data.DataPos;
import com.builtbroken.atomic.map.data.ThreadDataChange;
import com.builtbroken.atomic.map.data.storage.DataChunk;
import com.builtbroken.atomic.map.exposure.node.RadSourceMap;
import com.builtbroken.atomic.map.exposure.thread.RadServerTask;
import com.builtbroken.jlib.lang.StringHelpers;
import java.util.HashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class ThreadRadExposure
extends ThreadDataChange {
    public ThreadRadExposure() {
        super("ThreadRadExposure");
    }

    @Override
    protected boolean updateLocation(DataChange change) {
        long time = System.nanoTime();
        WorldServer world = DimensionManager.getWorld((int)change.dim());
        if (world != null) {
            HashMap<BlockPos, Integer> collectedData = this.updateValue((World)world, change.xi(), change.yi(), change.zi(), change.value);
            if (this.shouldRun) {
                world.func_152344_a((Runnable)new RadServerTask((IRadiationSource)change.source, collectedData));
            }
            if (AtomicScience.runningAsDev) {
                time = System.nanoTime() - time;
                AtomicScience.logger.info(String.format("ThreadRadExposure: %sx %sy %sz | %sn | took %s", change.xi(), change.yi(), change.zi(), change.value, StringHelpers.formatNanoTime(time)));
            }
            return true;
        }
        return false;
    }

    protected HashMap<BlockPos, Integer> updateValue(World world, int cx, int cy, int cz, int value) {
        if (value > 0) {
            HashMap<BlockPos, Integer> radiationData = new HashMap<BlockPos, Integer>();
            int rad = RadiationHandler.getRadFromMaterial(value);
            int edit_range = Math.min(ConfigThread.THREAD_RADS_PATHING_RANGE, (int)Math.floor(RadiationHandler.getDecayRange(rad)));
            if (edit_range > 1) {
                int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / (double)edit_range));
                for (int phi_n = 0; phi_n < 2 * steps; ++phi_n) {
                    for (int theta_n = 0; theta_n < 2 * steps; ++theta_n) {
                        double yaw = Math.PI * 2 / (double)steps * (double)phi_n;
                        double pitch = Math.PI * 2 / (double)steps * (double)theta_n;
                        double dx = Math.sin(pitch) * Math.cos(yaw) * 0.5;
                        double dy = Math.cos(pitch) * 0.5;
                        double dz = Math.sin(pitch) * Math.sin(yaw) * 0.5;
                        this.path(radiationData, world, (double)cx + 0.5, (double)cy + 0.5, (double)cz + 0.5, dx, dy, dz, rad, edit_range);
                    }
                }
            }
            return radiationData;
        }
        return new HashMap<BlockPos, Integer>();
    }

    protected void path(HashMap<BlockPos, Integer> radiationData, World world, double center_x, double center_y, double center_z, double dx, double dy, double dz, double power, double edit_range) {
        int cx = (int)Math.floor(center_x);
        int cy = (int)Math.floor(center_y);
        int cz = (int)Math.floor(center_z);
        double x = center_x;
        double y = center_y;
        double z = center_z;
        double distanceSQ = 1.0;
        double radDistance = 1.0;
        DataPos prevPos = null;
        do {
            if (!this.shouldRun) {
                return;
            }
            int xi = (int)Math.floor(x);
            int yi = (int)Math.floor(y);
            int zi = (int)Math.floor(z);
            if (y < 0.0 || y > (double)world.func_72800_K()) {
                return;
            }
            if (xi != cx || yi != cy || zi != cz) {
                double distanceX = center_x - ((double)xi + 0.5);
                double distanceY = center_y - ((double)yi + 0.5);
                double distanceZ = center_z - ((double)zi + 0.5);
                distanceSQ = distanceX * distanceX + distanceZ * distanceZ + distanceY * distanceY;
                DataPos pos = DataPos.get(xi, yi, zi);
                if (prevPos != pos) {
                    power = RadiationHandler.getRadForDistance(power, radDistance, distanceSQ);
                    power = RadiationHandler.reduceRadiationForBlock(world, xi, yi, zi, power);
                    int change = (int)Math.floor(power);
                    radiationData.put(pos.disposeReturnBlockPos(), change);
                    prevPos = pos;
                    radDistance = distanceSQ;
                } else {
                    pos.dispose();
                }
            }
            x += dx;
            y += dy;
            z += dz;
        } while (distanceSQ <= edit_range * edit_range && power > 1.0);
    }

    @Override
    protected void queueRemove(DataChunk chunk) {
        chunk.forEachValue((dim, x, y, z, value) -> this.queuePosition(DataChange.get(new RadSourceMap(dim, new BlockPos(x, y, z), value), 0)), DataMapType.RAD_MATERIAL);
    }

    @Override
    protected void queueAddition(DataChunk chunk) {
        chunk.forEachValue((dim, x, y, z, value) -> this.queuePosition(DataChange.get(new RadSourceMap(dim, new BlockPos(x, y, z), value), value)), DataMapType.RAD_MATERIAL);
    }
}

