/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.exposure.thread;

import com.builtbroken.atomic.api.radiation.IRadiationNode;
import com.builtbroken.atomic.api.radiation.IRadiationSource;
import com.builtbroken.atomic.map.exposure.node.RadiationNode;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.BlockPos;

public class RadServerTask
implements Runnable {
    public final IRadiationSource source;
    public final HashMap<BlockPos, Integer> collectedData;

    public RadServerTask(IRadiationSource source, HashMap<BlockPos, Integer> collectedData) {
        this.source = source;
        this.collectedData = collectedData;
    }

    @Override
    public void run() {
        HashMap<BlockPos, IRadiationNode> oldMap = this.source.getCurrentNodes();
        HashMap<BlockPos, IRadiationNode> newMap = new HashMap<BlockPos, IRadiationNode>();
        this.source.disconnectMapData();
        for (Map.Entry<BlockPos, Integer> entry : this.collectedData.entrySet()) {
            int value = entry.getValue();
            BlockPos pos = entry.getKey();
            if (oldMap != null && oldMap.containsKey(pos)) {
                IRadiationNode node = oldMap.get(pos);
                if (node != null) {
                    node.setRadiationValue(value);
                    newMap.put(pos, node);
                }
                oldMap.remove(pos);
                continue;
            }
            newMap.put(pos, RadiationNode.get(this.source, value));
        }
        this.source.disconnectMapData();
        this.source.clearMapData();
        this.source.setCurrentNodes(newMap);
        this.source.connectMapData();
        this.source.initMapData();
    }
}

