/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.exposure.node;

import com.builtbroken.atomic.api.map.DataMapType;
import com.builtbroken.atomic.api.radiation.IRadiationNode;
import com.builtbroken.atomic.api.radiation.IRadiationSource;
import com.builtbroken.atomic.map.data.node.MapNodeSource;
import net.minecraft.nbt.NBTTagCompound;

public abstract class RadiationSource<E>
extends MapNodeSource<E, IRadiationNode>
implements IRadiationSource {
    public static final String NBT_RAD = "rad";

    @Override
    public boolean isRadioactive() {
        return this.getRadioactiveMaterial() > 0;
    }

    @Override
    public boolean isStillValid() {
        return super.isStillValid() && this.isRadioactive();
    }

    @Override
    public DataMapType getType() {
        return DataMapType.RADIATION;
    }

    @Override
    public NBTTagCompound getSaveState() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a(NBT_RAD, this.getRadioactiveMaterial());
        return tagCompound;
    }

    @Override
    public boolean shouldQueueForUpdate(NBTTagCompound saveState) {
        int material = this.getRadioactiveMaterial();
        if (material > 0 && !this.hasNodes()) {
            return true;
        }
        return saveState == null || saveState.func_74762_e(NBT_RAD) != material;
    }

    @Override
    protected String addDebugInfo() {
        return "RAD: " + this.isRadioactive() + "-" + this.getRadioactiveMaterial() + ", ";
    }

    @Override
    protected String getDebugName() {
        return "RadiationSource";
    }
}

