/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.exposure.node;

import com.builtbroken.atomic.api.map.DataMapType;
import com.builtbroken.atomic.api.map.IDataMapSource;
import com.builtbroken.atomic.api.radiation.IRadiationNode;
import com.builtbroken.atomic.api.radiation.IRadiationSource;
import com.builtbroken.atomic.map.data.DataPool;
import com.builtbroken.atomic.map.data.IDataPoolObject;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;

public class RadiationNode
implements IRadiationNode,
IDataPoolObject {
    private static final DataPool<RadiationNode> RADIATION_NODE_POOL = new DataPool(400000);
    private WeakReference<IRadiationSource> source;
    private int value;

    private RadiationNode(IRadiationSource source, int value) {
        this.source = new WeakReference<IRadiationSource>(source);
        this.value = value;
    }

    @Override
    public int getRadiationValue() {
        return this.value;
    }

    @Override
    public void setRadiationValue(int value) {
        this.value = value;
    }

    @Override
    public DataMapType getType() {
        return DataMapType.RADIATION;
    }

    @Override
    @Nullable
    public IDataMapSource getSource() {
        if (this.source == null || this.source.get() == null) {
            return null;
        }
        return (IDataMapSource)this.source.get();
    }

    public static RadiationNode get(IRadiationSource source, int value) {
        RadiationNode dataChange;
        if (RADIATION_NODE_POOL.has() && (dataChange = RADIATION_NODE_POOL.get()) != null) {
            dataChange.source = new WeakReference<IRadiationSource>(source);
            dataChange.value = value;
            return dataChange;
        }
        return new RadiationNode(source, value);
    }

    @Override
    public void dispose() {
        this.source = null;
        RADIATION_NODE_POOL.dispose(this);
    }
}

