/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.exposure.node;

import com.builtbroken.atomic.map.exposure.node.RadiationSource;
import java.lang.ref.WeakReference;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class RadSourceTile<E extends TileEntity>
extends RadiationSource<E> {
    private final IntSupplier radFunction;
    private final BooleanSupplier activeFunction;
    private final WeakReference<E> hostReference;

    public RadSourceTile(E host, IntSupplier radFunction, BooleanSupplier activeFunction) {
        this.hostReference = new WeakReference<E>(host);
        this.radFunction = radFunction;
        this.activeFunction = activeFunction;
    }

    @Override
    public boolean isRadioactive() {
        return super.isRadioactive() && this.activeFunction.getAsBoolean();
    }

    @Override
    public int getRadioactiveMaterial() {
        return this.radFunction.getAsInt();
    }

    @Override
    public boolean doesSourceExist() {
        return this.world() != null && this.getHost() != null && !this.getHost().func_145837_r() && this.world().func_175625_s(this.getPos()) == this.getHost();
    }

    @Override
    public World world() {
        return this.getHost().func_145831_w();
    }

    @Override
    public double z() {
        return (double)this.getHost().func_174877_v().func_177952_p() + 0.5;
    }

    @Override
    public double x() {
        return (double)this.getHost().func_174877_v().func_177958_n() + 0.5;
    }

    @Override
    public double y() {
        return (double)this.getHost().func_174877_v().func_177956_o() + 0.5;
    }

    @Override
    public int zi() {
        return this.getHost().func_174877_v().func_177952_p();
    }

    @Override
    public int xi() {
        return this.getHost().func_174877_v().func_177958_n();
    }

    @Override
    public int yi() {
        return this.getHost().func_174877_v().func_177956_o();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RadSourceTile) {
            if (this.getHost() != null && ((RadSourceTile)object).getHost() != null) {
                return this.getHost().func_145831_w() == ((RadSourceTile)object).getHost().func_145831_w() && this.getHost().func_174877_v() == ((RadSourceTile)object).getHost().func_174877_v();
            }
            return ((RadSourceTile)object).getHost() == this.getHost();
        }
        return false;
    }

    @Override
    protected String getDebugName() {
        return "RadSourceTile";
    }

    @Override
    public E getHost() {
        return (E)((TileEntity)this.hostReference.get());
    }
}

