/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.events;

import com.builtbroken.atomic.api.map.DataMapType;
import com.builtbroken.atomic.api.map.IDataMapNode;
import com.builtbroken.atomic.map.data.storage.DataChunk;
import com.builtbroken.atomic.map.data.storage.DataMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class MapSystemEvent
extends Event {
    public final DataMap map;

    public MapSystemEvent(DataMap map) {
        this.map = map;
    }

    public int dim() {
        return this.map.dim;
    }

    public World world() {
        return DimensionManager.getWorld((int)this.map.dim);
    }

    public static class RemoveChunk
    extends MapSystemEvent {
        public final DataChunk chunk;

        public RemoveChunk(DataMap map, DataChunk chunk) {
            super(map);
            this.chunk = chunk;
        }
    }

    public static class AddChunk
    extends MapSystemEvent {
        public final DataChunk chunk;

        public AddChunk(DataMap map, DataChunk chunk) {
            super(map);
            this.chunk = chunk;
        }
    }

    public static class OnNodeRemoved
    extends OnValueChanged {
        public final int new_value;

        public OnNodeRemoved(DataMap map, DataMapType type, int x, int y, int z, int prev_value, int new_value) {
            super(map, type, x, y, z, prev_value);
            this.new_value = new_value;
        }

        @Override
        public int getNewValue() {
            return this.new_value;
        }
    }

    @Cancelable
    public static class OnNodeAdded
    extends OnValueChanged {
        public IDataMapNode node;

        public OnNodeAdded(DataMap map, DataMapType type, int x, int y, int z, int prev_value, IDataMapNode node) {
            super(map, type, x, y, z, prev_value);
            this.node = node;
        }

        @Override
        public int getNewValue() {
            if (this.node == null) {
                return this.prev_value;
            }
            return this.prev_value + this.type.getValue(this.node);
        }
    }

    public static class OnValueChanged
    extends MapSystemEvent {
        public final DataMapType type;
        public final int x;
        public final int y;
        public final int z;
        public final int prev_value;
        private BlockPos pos;

        public OnValueChanged(DataMap map, DataMapType type, int x, int y, int z, int prev_value) {
            super(map);
            this.type = type;
            this.x = x;
            this.y = y;
            this.z = z;
            this.prev_value = prev_value;
        }

        public int getNewValue() {
            return this.prev_value;
        }

        public BlockPos getPos() {
            if (this.pos == null) {
                this.pos = new BlockPos(this.x, this.y, this.z);
            }
            return this.pos;
        }
    }
}

