/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data.storage;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.map.DataMapType;
import com.builtbroken.atomic.api.map.IDataMapNode;
import com.builtbroken.atomic.api.map.IDataMapSource;
import com.builtbroken.atomic.map.MapSystem;
import com.builtbroken.atomic.map.data.storage.DataChunk;
import com.builtbroken.atomic.map.data.storage.DataMapException;
import com.builtbroken.atomic.map.events.MapSystemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DataMap {
    public final MapSystem mapSystem;
    public final int dim;
    protected final HashMap<Long, DataChunk> chunksCurrentlyLoaded = new HashMap();
    protected final HashMap<Long, DataChunk> chunksWaitingToUnload = new HashMap();

    public DataMap(MapSystem mapSystem, int dim) {
        this.mapSystem = mapSystem;
        this.dim = dim;
    }

    public int getValue(@Nonnull BlockPos pos, @Nonnull DataMapType type) {
        return type.getValue(this.getData(pos));
    }

    public int getValue(int x, int y, int z, @Nonnull DataMapType type) {
        return type.getValue(this.getData(x, y, z));
    }

    @Nullable
    public ArrayList<IDataMapNode> getData(@Nonnull BlockPos pos) {
        return this.getData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Nullable
    public ArrayList<IDataMapNode> getData(int x, int y, int z) {
        DataChunk chunk = this.getChunkFromPosition(x, z, false);
        if (chunk != null) {
            return chunk.getData(x & 0xF, y, z & 0xF);
        }
        return null;
    }

    public void addData(@Nonnull BlockPos pos, @Nonnull IDataMapNode node) {
        this.addData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), node);
    }

    public void addData(int x, int y, int z, @Nonnull IDataMapNode node) {
        DataChunk chunk = this.getChunkFromPosition(x, z, true);
        if (chunk != null) {
            Chunk worldChunk;
            int prev = node.getType().getValue(this.getData(x, y, z));
            MapSystemEvent.OnNodeAdded event = new MapSystemEvent.OnNodeAdded(this, node.getType(), x, y, z, prev, node);
            if (MinecraftForge.EVENT_BUS.post((Event)event) || event.node == null) {
                return;
            }
            chunk.addData(x & 0xF, y, z & 0xF, event.node);
            WorldServer world = DimensionManager.getWorld((int)this.dim);
            if (world != null && (worldChunk = world.func_72964_e(x >> 4, z >> 4)) != null) {
                worldChunk.func_177427_f(true);
            }
        }
    }

    public boolean removeData(@Nonnull BlockPos pos, @Nonnull IDataMapNode node) {
        return this.removeData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), node);
    }

    public boolean removeData(int x, int y, int z, @Nonnull IDataMapNode node) {
        DataChunk chunk;
        if (node != null && (chunk = this.getChunkFromPosition(x, z, false)) != null) {
            int prev = node.getType().getValue(this.getData(x, y, z));
            if (chunk.removeData(x & 0xF, y, z & 0xF, node)) {
                this.fireChangeEvent(node.getType(), x, y, z, prev);
            }
        }
        return false;
    }

    public boolean removeData(@Nonnull BlockPos pos, @Nonnull IDataMapSource source) {
        return this.removeData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), source);
    }

    public boolean removeData(int x, int y, int z, @Nonnull IDataMapSource source) {
        if (y < 0 || y > source.world().func_72800_K()) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.error("DataMap[" + this.dim + "]: Something tried to remove a block outside map, pos(" + x + ", " + y + ", " + z + ") source(" + source + ")", (Throwable)new DataMapException());
            }
            return false;
        }
        DataChunk chunk = this.getChunkFromPosition(x, z, false);
        if (chunk != null) {
            int prev = source.getType().getValue(this.getData(x, y, z));
            if (chunk.removeData(x & 0xF, y, z & 0xF, source)) {
                this.fireChangeEvent(source.getType(), x, y, z, prev);
            }
        }
        return false;
    }

    private final void fireChangeEvent(@Nonnull DataMapType type, int x, int y, int z, int prev) {
        int current = type.getValue(this.getData(x, y, z));
        if (prev != current) {
            MinecraftForge.EVENT_BUS.post((Event)new MapSystemEvent.OnNodeRemoved(this, type, x, y, z, prev, current));
        }
    }

    @Nullable
    public World getWorld() {
        return DimensionManager.getWorld((int)this.dim);
    }

    public Collection<DataChunk> getLoadedChunks() {
        return this.chunksCurrentlyLoaded.values();
    }

    public void onWorldUnload() {
        this.clearData();
    }

    public void clearData() {
        this.chunksCurrentlyLoaded.clear();
    }

    public void onWorldTick(World world) {
        Long time = System.currentTimeMillis();
        DataChunk chunkScaned = null;
        for (DataChunk chunk : this.getLoadedChunks()) {
            if (chunk.lastScanTime - time <= 60000L) continue;
            chunkScaned = chunk;
            chunk.lastScanTime = time;
            chunk.checkForIssues();
            break;
        }
        if (chunkScaned != null && !chunkScaned.hasData()) {
            this.chunksWaitingToUnload.put(this.index(chunkScaned.xPosition, chunkScaned.zPosition), chunkScaned);
        }
        Iterator<Map.Entry<Long, DataChunk>> it = this.chunksWaitingToUnload.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, DataChunk> entry = it.next();
            DataChunk chunk = entry.getValue();
            if (chunk == null) {
                it.remove();
                continue;
            }
            if (world.func_72863_F().func_186026_b(chunk.xPosition, chunk.zPosition) != null) {
                this.chunksCurrentlyLoaded.put(entry.getKey(), chunk);
                it.remove();
                continue;
            }
            if (entry.getValue().unloadTick++ <= 1000) continue;
            MinecraftForge.EVENT_BUS.post((Event)new MapSystemEvent.RemoveChunk(this, entry.getValue()));
            it.remove();
        }
    }

    public void unloadChunk(Chunk chunk) {
        long index = this.index(chunk);
        if (this.chunksCurrentlyLoaded.containsKey(index)) {
            this.chunksWaitingToUnload.put(index, this.chunksCurrentlyLoaded.get(index));
            this.chunksCurrentlyLoaded.remove(index);
        }
    }

    protected DataChunk createNewChunk(int dim, int chunkX, int chunkZ) {
        long index = this.index(chunkX, chunkZ);
        DataChunk radiationChunk = new DataChunk(dim, chunkX, chunkZ);
        this.chunksCurrentlyLoaded.put(index, radiationChunk);
        return radiationChunk;
    }

    public DataChunk getChunkFromPosition(int x, int z, boolean init) {
        return this.getChunk(x >> 4, z >> 4, init);
    }

    public DataChunk getChunk(int chunk_x, int chunk_z, boolean init) {
        DataChunk chunk = this.findChunk(chunk_x, chunk_z, init);
        if (chunk == null && init) {
            chunk = this.createNewChunk(this.dim, chunk_x, chunk_z);
        }
        return chunk;
    }

    protected DataChunk findChunk(int chunk_x, int chunk_z, boolean load) {
        return this.findChunk(this.index(chunk_x, chunk_z), load);
    }

    protected DataChunk findChunk(long index, boolean load) {
        DataChunk chunk = this.chunksCurrentlyLoaded.get(index);
        if (chunk == null && load && (chunk = this.chunksWaitingToUnload.get(index)) != null) {
            this.chunksWaitingToUnload.remove(index);
            this.chunksCurrentlyLoaded.put(index, chunk);
            chunk.unloadTick = 0;
        }
        return chunk;
    }

    protected long index(Chunk chunk) {
        return this.index(chunk.field_76635_g, chunk.field_76647_h);
    }

    protected long index(int chunkX, int chunkZ) {
        return ChunkPos.func_77272_a((int)chunkX, (int)chunkZ);
    }
}

