/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data.storage;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.map.DataMapType;
import com.builtbroken.atomic.api.map.IDataMapNode;
import com.builtbroken.atomic.api.map.IDataMapSource;
import com.builtbroken.atomic.map.data.storage.DataChunk;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;

public class DataLayer {
    public final int y_index;
    public final DataChunk host;
    private final ArrayList<IDataMapNode>[] data;
    public int blocksUsed = 0;

    public DataLayer(DataChunk host, int y_index) {
        this.y_index = y_index;
        this.host = host;
        this.data = new ArrayList[256];
    }

    public ArrayList<IDataMapNode> getData(int x, int z) {
        int index = this.index(x, z);
        if (index >= 0) {
            return this.data[index];
        }
        return null;
    }

    public void forEach(int x, int z, DataMapType type, Consumer<IDataMapNode> consumer) {
        ArrayList<IDataMapNode> list = this.getData(x, z);
        if (list != null) {
            for (IDataMapNode node : list) {
                if (node == null || node.getType() != type) continue;
                consumer.accept(node);
            }
        }
    }

    public boolean removeData(IDataMapSource source) {
        int count = 0;
        for (int i = 0; i < 256; ++i) {
            count += this.removeData(source, this.data[i]);
        }
        this.blocksUsed -= count;
        return count > 0;
    }

    public boolean removeData(int x, int z, IDataMapSource source) {
        int count = this.removeData(source, this.getData(x, z));
        this.blocksUsed -= count;
        return count > 0;
    }

    public boolean removeData(int x, int z, IDataMapNode node) {
        ArrayList<IDataMapNode> list = this.getData(x, z);
        if (list != null && list.remove(node)) {
            --this.blocksUsed;
            return true;
        }
        return false;
    }

    private int removeData(IDataMapSource source, ArrayList<IDataMapNode> list) {
        int count = 0;
        if (list != null && !list.isEmpty()) {
            Iterator<IDataMapNode> it = list.iterator();
            while (it.hasNext()) {
                IDataMapNode node = it.next();
                if (node == null || !node.isNodeValid()) {
                    it.remove();
                    continue;
                }
                if (!source.equals(node.getSource())) continue;
                it.remove();
                ++count;
            }
        }
        return count;
    }

    public void addData(int x, int z, IDataMapNode node) {
        int index = this.index(x, z);
        if (index >= 0) {
            if (this.data[index] == null) {
                this.data[index] = new ArrayList();
            }
            this.data[index].add(node);
            ++this.blocksUsed;
        } else if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("DataLayer[" + this.y_index + ", " + this.host + "] Something tried to insert outside of the layer's bounds at [" + x + ", " + z + "]", (Throwable)new RuntimeException("trace"));
        }
    }

    public final int index(int x, int z) {
        if (x >= 0 && x < 16 && z >= 0 && z < 16) {
            return x * 16 + z;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.blocksUsed <= 0;
    }

    public void checkForIssues() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] == null) continue;
            Iterator<IDataMapNode> it = this.data[i].iterator();
            while (it.hasNext()) {
                IDataMapNode node = it.next();
                if (node.isNodeValid()) continue;
                it.remove();
            }
            if (this.data[i].size() > 0) continue;
            this.data[i] = null;
        }
    }
}

