/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data.storage;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.map.DataMapType;
import com.builtbroken.atomic.api.map.IDataMapNode;
import com.builtbroken.atomic.api.map.IDataMapSource;
import com.builtbroken.atomic.map.data.MapValueConsumer;
import com.builtbroken.atomic.map.data.storage.DataLayer;
import com.builtbroken.atomic.map.data.storage.DataMapException;
import java.util.ArrayList;

public class DataChunk {
    public final int xPosition;
    public final int zPosition;
    public final int dimension;
    public int unloadTick = 0;
    public Long lastScanTime = System.currentTimeMillis();
    protected DataLayer[] layers = new DataLayer[256];
    protected int yStart;

    public DataChunk(int dimension, int xPosition, int zPosition) {
        this.dimension = dimension;
        this.xPosition = xPosition;
        this.zPosition = zPosition;
    }

    protected int getChunkHeight() {
        return 256;
    }

    public void addData(int cx, int y, int cz, IDataMapNode node) {
        if (y >= 0 && y < this.getChunkHeight()) {
            this.getLayer(y).addData(cx, cz, node);
        } else if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("DataChunk[" + this.xPosition + "," + this.zPosition + "]: Something tried to place a block outside map", (Throwable)new RuntimeException("trace"));
        }
    }

    public boolean removeData(int cx, int y, int cz, IDataMapNode node) {
        if (y >= 0 && y < this.getChunkHeight()) {
            return this.getLayer(y).removeData(cx, cz, node);
        }
        if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("DataChunk[" + this.xPosition + "," + this.zPosition + "]: Something tried to remove a block outside map", (Throwable)new RuntimeException("trace"));
        }
        return false;
    }

    public boolean removeData(int cx, int y, int cz, IDataMapSource source) {
        if (y >= 0 && y < this.getChunkHeight()) {
            return this.getLayer(y).removeData(cx, cz, source);
        }
        if (AtomicScience.runningAsDev) {
            AtomicScience.logger.error("DataChunk[" + this.xPosition + "," + this.zPosition + "]: Something tried to remove a block outside map, pos(" + cx + ", " + y + ", " + cz + ")", (Throwable)new DataMapException());
        }
        return false;
    }

    public ArrayList<IDataMapNode> getData(int cx, int y, int cz) {
        if (y >= 0 && y < this.getChunkHeight() && this.hasLayer(y)) {
            return this.getLayer(y).getData(cx, cz);
        }
        return null;
    }

    protected boolean hasLayer(int y) {
        return this.getLayers() != null && y >= this.getYStart() && y <= this.getLayerEnd() && this.getLayers()[this.getIndex(y)] != null;
    }

    public int getLayerEnd() {
        return this.getYStart() + this.getLayers().length - 1;
    }

    protected void removeLayer(int y) {
        int index = this.getIndex(y);
        if (index >= 0 && index < this.getLayers().length) {
            this.getLayers()[index] = null;
        }
    }

    public DataLayer getLayer(int y) {
        if (this.getLayers()[this.getIndex(y)] == null) {
            this.getLayers()[this.getIndex((int)y)] = new DataLayer(this, y);
        }
        return this.getLayers()[this.getIndex(y)];
    }

    protected int getIndex(int y) {
        return y - this.getYStart();
    }

    public DataLayer[] getLayers() {
        return this.layers;
    }

    public int getYStart() {
        return this.yStart;
    }

    public boolean hasData() {
        for (DataLayer layer : this.getLayers()) {
            if (layer == null || layer.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void checkForIssues() {
        for (int i = 0; i < this.getLayers().length; ++i) {
            DataLayer layer = this.getLayers()[i];
            if (layer == null) continue;
            layer.checkForIssues();
            if (!layer.isEmpty()) continue;
            this.getLayers()[i] = null;
        }
    }

    public final void forEachValue(MapValueConsumer consumer, DataMapType type) {
        for (DataLayer layer : this.getLayers()) {
            if (layer == null || layer.blocksUsed <= 0) continue;
            for (int cx = 0; cx < 16; ++cx) {
                for (int cz = 0; cz < 16; ++cz) {
                    int value;
                    ArrayList<IDataMapNode> list = layer.getData(cx, cz);
                    if (list == null || list.isEmpty() || (value = type.getValue(list)) <= 0) continue;
                    int x = cx + this.xPosition * 16;
                    int z = cz + this.xPosition * 16;
                    consumer.accept(this.dimension, x, layer.y_index, z, value);
                }
            }
        }
    }
}

