/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data.node;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.map.DataMapType;
import com.builtbroken.atomic.api.map.IDataMapNode;
import com.builtbroken.atomic.api.map.IDataMapSource;
import com.builtbroken.atomic.map.MapHandler;
import com.builtbroken.atomic.map.data.IDataPoolObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class MapNodeSource<E, N extends IDataMapNode>
implements IDataMapSource {
    public HashMap<BlockPos, N> nodes;
    private boolean connected = false;

    public HashMap<BlockPos, N> getCurrentNodes() {
        return this.nodes;
    }

    public int getNodeCount() {
        return this.nodes != null ? this.nodes.size() : -1;
    }

    protected boolean hasNodes() {
        return this.nodes != null && !this.nodes.isEmpty();
    }

    @Override
    public boolean isStillValid() {
        return this.doesSourceExist();
    }

    @Override
    public boolean doesSourceExist() {
        return this.world() != null;
    }

    public void setCurrentNodes(HashMap<BlockPos, N> map) {
        this.nodes = map;
    }

    @Override
    public DataMapType getType() {
        return DataMapType.RADIATION;
    }

    @Override
    public boolean hasMapData() {
        return this.nodes != null && !this.nodes.isEmpty();
    }

    @Override
    public boolean hasActiveMapData() {
        return this.hasMapData() && this.connected;
    }

    @Override
    public void clearMapData() {
        if (this.connected) {
            AtomicScience.logger.error("MapNodeSource#clearMapData() an attempt was made to clear map data without disconnecting", (Throwable)new RuntimeException("trace"));
            this.disconnectMapData();
        }
        if (this.getCurrentNodes() != null) {
            for (IDataMapNode node : this.getCurrentNodes().values()) {
                if (!(node instanceof IDataPoolObject)) continue;
                ((IDataPoolObject)((Object)node)).dispose();
            }
            this.getCurrentNodes().clear();
        }
    }

    @Override
    public void disconnectMapData() {
        this.connected = false;
        if (this.getCurrentNodes() != null) {
            for (BlockPos pos : this.getCurrentNodes().keySet()) {
                MapHandler.GLOBAL_DATA_MAP.removeData(this.world(), pos, (IDataMapSource)this);
            }
        }
    }

    @Override
    public void connectMapData() {
        this.connected = true;
        if (this.getCurrentNodes() != null) {
            for (Map.Entry<BlockPos, N> entry : this.getCurrentNodes().entrySet()) {
                MapHandler.GLOBAL_DATA_MAP.addData(this.world(), entry.getKey(), (IDataMapNode)entry.getValue());
            }
        }
    }

    @Override
    public abstract World world();

    @Override
    public int dim() {
        return this.world().field_73011_w.getDimension();
    }

    public String toString() {
        return this.getDebugName() + "[H: " + this.getHost() + ", N: " + this.getNodeCount() + ", D: " + this.dim() + ", P: (" + this.xi() + ", " + this.yi() + ", " + this.zi() + "), V: " + this.isStillValid() + ", E: " + this.doesSourceExist() + this.addDebugInfo() + "]@" + this.hashCode();
    }

    protected String addDebugInfo() {
        return "";
    }

    protected abstract String getDebugName();

    public abstract E getHost();
}

