/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data.node;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.api.map.IDataMapSource;
import com.builtbroken.atomic.map.data.node.MapSourceInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="atomicscience")
public final class MapDataSources {
    private static final List<IDataMapSource> sources = new ArrayList<IDataMapSource>();
    private static final HashMap<IDataMapSource, MapSourceInfo> sourceInfo = new HashMap();
    private static final List<IDataMapSource> waitingForThread = new ArrayList<IDataMapSource>();
    private static boolean callChecked = false;

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (!callChecked) {
            callChecked = true;
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.info("MapDataSources#serverTick() is working");
            }
        }
        Iterator<IDataMapSource> it = sources.iterator();
        while (it.hasNext()) {
            IDataMapSource source = it.next();
            try {
                if (source == null || !source.doesSourceExist()) {
                    it.remove();
                    MapDataSources.onSourceRemoved(source);
                    if (!AtomicScience.runningAsDev) continue;
                    AtomicScience.logger.info("MapDataSources#serverTick() - Removed dead source, " + source);
                    continue;
                }
                if (!source.isStillValid()) {
                    if (!source.hasActiveMapData()) continue;
                    if (AtomicScience.runningAsDev) {
                        AtomicScience.logger.info("MapDataSources#serverTick() - Disconnected map data, " + source);
                    }
                    source.disconnectMapData();
                    waitingForThread.remove(source);
                    sourceInfo.remove(source);
                    continue;
                }
                MapSourceInfo info = sourceInfo.get(source);
                if (info == null) {
                    info = new MapSourceInfo(source);
                    sourceInfo.put(source, info);
                }
                source.update();
                if (waitingForThread.contains(source) || !info.needsQueued()) continue;
                if (AtomicScience.runningAsDev) {
                    AtomicScience.logger.info("MapDataSources#serverTick() - Marked source for update, " + source);
                }
                source.getType().queueSourceForUpdate(source);
                info.logState();
            }
            catch (Exception e) {
                AtomicScience.logger.error("MapDataSources#serverTick() - Unexpected error while checking source, " + source, (Throwable)e);
            }
        }
    }

    public static void addSource(IDataMapSource source) {
        if (source != null && !source.world().field_72995_K && source.doesSourceExist() && !sources.contains(source)) {
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.info("MapDataSources#addSource(" + source + ")");
            }
            sources.add(source);
        }
    }

    public static void removeSource(IDataMapSource source) {
        if (sources.contains(source)) {
            sources.remove(source);
            MapDataSources.onSourceRemoved(source);
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.info("MapDataSources#removeSource(" + source + ")");
            }
        }
    }

    private static void onSourceRemoved(IDataMapSource source) {
        waitingForThread.remove(source);
        sourceInfo.remove(source);
        source.onRemovedFromMap();
    }

    public static void addSource(Entity entity) {
    }

    public static void removeSource(Entity entity) {
    }

    public static void onAddedToThread(IDataMapSource source) {
        waitingForThread.add(source);
    }

    public static void onRemovedFromThread(IDataMapSource source) {
        waitingForThread.remove(source);
    }
}

