/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.map.data.DataChange;
import com.builtbroken.atomic.map.data.storage.DataChunk;
import com.builtbroken.jlib.data.vector.IPos3D;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class ThreadDataChange
extends Thread {
    public final String name;
    public boolean shouldRun = true;
    private ConcurrentLinkedQueue<DataChange> changeQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<DataChunk> addScanQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<DataChunk> removeScanQueue = new ConcurrentLinkedQueue();

    public ThreadDataChange(String name) {
        super(null, null, "atomicscience:" + name, 0L);
        this.name = name;
        this.setPriority(3);
        this.setDaemon(true);
    }

    @Override
    public void start() {
        this.shouldRun = true;
        AtomicScience.logger.info(this.name + ": Starting thread");
        super.start();
    }

    @Override
    public void run() {
        while (this.shouldRun) {
            try {
                DataChunk chunk;
                while (this.shouldRun && !this.removeScanQueue.isEmpty()) {
                    chunk = this.removeScanQueue.poll();
                    if (chunk == null) continue;
                    this.queueRemove(chunk);
                }
                while (this.shouldRun && !this.addScanQueue.isEmpty()) {
                    chunk = this.addScanQueue.poll();
                    if (chunk == null) continue;
                    this.queueAddition(chunk);
                }
                while (this.shouldRun && !this.changeQueue.isEmpty() && this.addScanQueue.isEmpty() && this.removeScanQueue.isEmpty()) {
                    DataChange change = this.changeQueue.poll();
                    if (change != null) {
                        if (this.updateLocation(change)) {
                            if (change.completionListener != null) {
                                change.completionListener.accept(change.source);
                            }
                            change.source.onThreadComplete();
                            change.dispose();
                            continue;
                        }
                        this.changeQueue.add(change);
                        continue;
                    }
                    change.dispose();
                }
                ThreadDataChange.sleep(100L);
            }
            catch (Exception e) {
                AtomicScience.logger.error(this.name + ": Unexpected error during operation", (Throwable)e);
            }
        }
        this.removeScanQueue.clear();
        this.addScanQueue.clear();
        this.changeQueue.clear();
    }

    protected void queueRemove(DataChunk chunk) {
    }

    protected void queueAddition(DataChunk chunk) {
    }

    protected boolean inRange(IPos3D center, int i, int j, int k, int range) {
        return this.inRange(center.xi(), i, range) && this.inRange(center.yi(), j, range) && this.inRange(center.zi(), k, range);
    }

    protected boolean inRange(int x, int i, int range) {
        int delta = x - i;
        return delta < range && delta > -range;
    }

    protected abstract boolean updateLocation(DataChange var1);

    public void kill() {
        this.shouldRun = false;
        AtomicScience.logger.info(this.name + ": Stopping thread");
    }

    public void queueChunkForRemoval(DataChunk chunk) {
        if (chunk != null && chunk.hasData()) {
            this.removeScanQueue.add(chunk);
        }
    }

    public void queueChunkForAddition(DataChunk chunk) {
        if (chunk != null && chunk.hasData()) {
            this.addScanQueue.add(chunk);
        }
    }

    public void queuePosition(DataChange change) {
        if (change != null) {
            this.changeQueue.add(change);
            if (AtomicScience.runningAsDev) {
                AtomicScience.logger.info(String.format(this + ": Queued to thread a new change %sx %sy %sz | %sn", change.xi(), change.yi(), change.zi(), change.value));
            }
        }
    }
}

