/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data;

import com.builtbroken.atomic.lib.transform.IPosWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public abstract class DataSourceWrapper<S extends IPosWorld>
implements IPosWorld {
    public final S source;
    public int dim;
    public double x;
    public double y;
    public double z;

    public DataSourceWrapper(S source) {
        this.source = source;
    }

    public boolean hasSourceChanged() {
        return this.dim != this.source.world().field_73011_w.getDimension() || this.hasDistanceChanged();
    }

    protected boolean hasDistanceChanged() {
        return this.distanceChangeEnough(this.x, this.source.x()) || this.distanceChangeEnough(this.y, this.source.y()) || this.distanceChangeEnough(this.z, this.source.z());
    }

    private boolean distanceChangeEnough(double prev, double current) {
        double delta = prev - current;
        return delta > 0.1 || delta < -0.1;
    }

    public void logCurrentData() {
        this.dim = this.source.world().field_73011_w.getDimension();
        if (this.hasDistanceChanged()) {
            this.x = this.source.x();
            this.y = this.source.y();
            this.z = this.source.z();
        }
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public World world() {
        return DimensionManager.getWorld((int)this.dim()) != null ? DimensionManager.getWorld((int)this.dim()) : this.source.world();
    }

    @Override
    public int dim() {
        return this.dim;
    }
}

