/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data;

import com.builtbroken.atomic.map.data.DataPool;
import com.builtbroken.jlib.data.vector.IPos3D;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

@Deprecated
public class DataPos
implements IPos3D {
    private static final DataPool<DataPos> dataPosPool = new DataPool(100000);
    private int x;
    private int y;
    private int z;
    private boolean released = false;
    private boolean mutable = true;

    protected DataPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static DataPos get(IPos3D pos) {
        return DataPos.get(pos.xi(), pos.yi(), pos.zi());
    }

    public static DataPos get(IPos3D pos, EnumFacing direction) {
        int i = pos.xi() + direction.func_82601_c();
        int j = pos.yi() + direction.func_96559_d();
        int k = pos.zi() + direction.func_82599_e();
        return DataPos.get(i, j, k);
    }

    public static DataPos get(int x, int y, int z, EnumFacing direction) {
        int i = x + direction.func_82601_c();
        int j = y + direction.func_96559_d();
        int k = z + direction.func_82599_e();
        return DataPos.get(i, j, k);
    }

    public static DataPos get(int x, int y, int z) {
        DataPos dataPos;
        if (dataPosPool.has() && (dataPos = dataPosPool.get()) != null && dataPos.released) {
            dataPos.unlock();
            dataPos.set(x, y, z);
            dataPos.released = false;
            return dataPos;
        }
        return new DataPos(x, y, z);
    }

    @Override
    public double z() {
        return this.z;
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public int zi() {
        return this.z;
    }

    @Override
    public int xi() {
        return this.x;
    }

    @Override
    public int yi() {
        return this.y;
    }

    public void set(int x, int y, int z) {
        if (!this.mutable) {
            throw new RuntimeException(this + " is locked from being changed");
        }
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public DataPos lock() {
        this.mutable = false;
        return this;
    }

    public DataPos unlock() {
        this.mutable = true;
        return this;
    }

    public double distanceSQ(DataPos pos) {
        int dx = pos.x - this.x;
        int dy = pos.y - this.y;
        int dz = pos.z - this.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distance(DataPos pos) {
        return Math.sqrt(this.distanceSQ(pos));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DataPos) {
            return this.x == ((DataPos)object).x && this.y == ((DataPos)object).y && this.z == ((DataPos)object).z;
        }
        return false;
    }

    public int hashCode() {
        return (this.yi() + this.zi() * 31) * 31 + this.xi();
    }

    public String toString() {
        if (this.released) {
            return "DataPos[Pooled]";
        }
        return String.format("DataPos[%d, %d, %d]", this.x, this.y, this.z);
    }

    public void dispose() {
        if (this.released) {
            throw new RuntimeException(this + " has already been released");
        }
        if (!this.mutable) {
            throw new RuntimeException(this + " is locked and can not be recycled until unlocked.");
        }
        this.released = true;
        dataPosPool.dispose(this.lock());
    }

    public BlockPos disposeReturnBlockPos() {
        BlockPos pos = new BlockPos(this.xi(), this.yi(), this.zi());
        this.dispose();
        return pos;
    }
}

