/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map.data;

import com.builtbroken.atomic.api.map.IDataMapSource;
import com.builtbroken.atomic.lib.transform.IPosWorld;
import com.builtbroken.atomic.map.data.DataPool;
import java.util.function.Consumer;
import net.minecraft.world.World;

public class DataChange
implements IPosWorld {
    private static final DataPool<DataChange> dataChangePool = new DataPool(100000);
    public IDataMapSource source;
    public Consumer<IDataMapSource> completionListener;
    public int value;

    private DataChange(IDataMapSource source, int value) {
        this.source = source;
        this.value = value;
    }

    public static DataChange get(IDataMapSource source, int value) {
        DataChange dataChange;
        if (dataChangePool.has() && (dataChange = dataChangePool.get()) != null) {
            dataChange.source = source;
            dataChange.value = value;
            dataChange.completionListener = null;
            return dataChange;
        }
        return new DataChange(source, value);
    }

    public void dispose() {
        dataChangePool.dispose(this);
    }

    @Override
    public World world() {
        return this.source.world();
    }

    @Override
    public int dim() {
        return this.source.dim();
    }

    @Override
    public double x() {
        return this.source.x();
    }

    @Override
    public double y() {
        return this.source.y();
    }

    @Override
    public double z() {
        return this.source.z();
    }
}

