/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map;

import com.builtbroken.atomic.api.map.IDataMapNode;
import com.builtbroken.atomic.api.map.IDataMapSource;
import com.builtbroken.atomic.map.data.storage.DataMap;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class MapSystem {
    protected final HashMap<Integer, DataMap> dimensionToMap = new HashMap();

    public DataMap getMap(int dim, boolean init) {
        DataMap map = this.dimensionToMap.get(dim);
        if (map == null && init) {
            map = this.newMap(dim);
            this.dimensionToMap.put(dim, map);
        }
        return map;
    }

    protected DataMap newMap(int dim) {
        return new DataMap(this, dim);
    }

    public DataMap getMap(World world, boolean init) {
        if (world != null && world.field_73011_w != null) {
            return this.getMap(world.field_73011_w.getDimension(), init);
        }
        return null;
    }

    public ArrayList<IDataMapNode> getData(World world, BlockPos pos) {
        DataMap map = this.getMap(world, false);
        if (map != null) {
            return map.getData(pos);
        }
        return null;
    }

    public ArrayList<IDataMapNode> getData(World world, int x, int y, int z) {
        DataMap map = this.getMap(world, false);
        if (map != null) {
            return map.getData(x, y, z);
        }
        return null;
    }

    public ArrayList<IDataMapNode> getData(int dim, BlockPos pos) {
        DataMap map = this.getMap(dim, false);
        if (map != null) {
            return map.getData(pos);
        }
        return null;
    }

    public ArrayList<IDataMapNode> getData(int dim, int x, int y, int z) {
        DataMap map = this.getMap(dim, false);
        if (map != null) {
            return map.getData(x, y, z);
        }
        return null;
    }

    public void addData(int dim, int x, int y, int z, IDataMapNode node) {
        DataMap map = this.getMap(dim, node != null);
        if (map != null) {
            map.addData(x, y, z, node);
        }
    }

    public void addData(World world, BlockPos pos, IDataMapNode node) {
        DataMap map = this.getMap(world, node != null);
        if (map != null) {
            map.addData(pos, node);
        }
    }

    public void addData(int dim, BlockPos pos, IDataMapNode node) {
        DataMap map = this.getMap(dim, node != null);
        if (map != null) {
            map.addData(pos, node);
        }
    }

    public boolean removeData(World world, BlockPos pos, IDataMapSource source) {
        DataMap map = this.getMap(world, false);
        if (map != null) {
            return map.removeData(pos, source);
        }
        return false;
    }

    public boolean removeData(int dim, BlockPos pos, IDataMapSource source) {
        DataMap map = this.getMap(dim, false);
        if (map != null) {
            return map.removeData(pos, source);
        }
        return false;
    }

    public boolean removeData(int dim, int x, int y, int z, IDataMapSource source) {
        DataMap map = this.getMap(dim, false);
        if (map != null) {
            return map.removeData(x, y, z, source);
        }
        return false;
    }

    public boolean removeData(int dim, int x, int y, int z, IDataMapNode node) {
        DataMap map = this.getMap(dim, false);
        if (map != null) {
            return map.removeData(x, y, z, node);
        }
        return false;
    }

    public void onWorldUnload(World world) {
        DataMap map = this.getMap(world, false);
        if (map != null) {
            map.onWorldUnload();
        }
    }

    public void onWorldTick(World world) {
        DataMap map = this.getMap(world, false);
        if (map != null) {
            map.onWorldTick(world);
        }
    }

    public void onChunkUnload(World world, Chunk chunk) {
        DataMap map = this.getMap(world, false);
        if (map != null) {
            map.unloadChunk(chunk);
        }
    }
}

