/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.map;

import com.builtbroken.atomic.api.AtomicScienceAPI;
import com.builtbroken.atomic.config.logic.ConfigRadiation;
import com.builtbroken.atomic.map.MapSystem;
import com.builtbroken.atomic.map.exposure.RadiationMap;
import com.builtbroken.atomic.map.exposure.thread.ThreadRadExposure;
import com.builtbroken.atomic.map.thermal.ThermalMap;
import com.builtbroken.atomic.map.thermal.thread.ThreadThermalAction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class MapHandler {
    public static final String RAD_EXPOSURE_MAP_ID = "atomicscience:radiation_exposure";
    public static final String RAD_MATERIAL_MAP_ID = "atomicscience:radiation_material";
    public static final String NBT_RAD_CHUNK = "atomicscience:radiation_data";
    public static final RadiationMap RADIATION_MAP = new RadiationMap();
    public static final ThermalMap THERMAL_MAP = new ThermalMap();
    public static final MapSystem GLOBAL_DATA_MAP = new MapSystem();
    public static ThreadRadExposure THREAD_RAD_EXPOSURE;
    public static ThreadThermalAction THREAD_THERMAL_ACTION;
    public static final MapHandler INSTANCE;

    public static void register() {
        AtomicScienceAPI.radiationExposureSystem = RADIATION_MAP;
        AtomicScienceAPI.thermalSystem = THERMAL_MAP;
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        if (ConfigRadiation.ENABLE_MAP) {
            MinecraftForge.EVENT_BUS.register((Object)RADIATION_MAP);
        }
        MinecraftForge.EVENT_BUS.register((Object)THERMAL_MAP);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            RADIATION_MAP.onWorldUnload(event.getWorld());
            THERMAL_MAP.onWorldUnload(event.getWorld());
            GLOBAL_DATA_MAP.onWorldUnload(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            GLOBAL_DATA_MAP.onChunkUnload(event.getWorld(), event.getChunk());
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K) {
            GLOBAL_DATA_MAP.onWorldTick(event.world);
        }
    }

    static {
        INSTANCE = new MapHandler();
    }
}

