/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.vapor;

import com.builtbroken.atomic.AtomicScience;
import com.builtbroken.atomic.config.logic.ConfigLogic;
import com.builtbroken.atomic.lib.vapor.IVaporData;
import com.builtbroken.atomic.lib.vapor.IVaporPathData;
import com.builtbroken.atomic.lib.vapor.VaporData;
import com.builtbroken.atomic.lib.vapor.VaporPathData;
import com.builtbroken.atomic.map.MapHandler;
import java.util.HashMap;
import java.util.function.IntSupplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class VaporHandler {
    public static final int WATER_HEAT_MIN = 100;
    private static final HashMap<Block, IVaporData> vaporDataMap = new HashMap();
    private static final HashMap<Block, IVaporPathData> vaporPathMap = new HashMap();

    public static void setVaporData(Block block, IntSupplier minHeat, IntSupplier vaporMin, IntSupplier vaporMax) {
        if (!vaporDataMap.containsKey(block)) {
            vaporDataMap.put(block, new VaporData(minHeat, vaporMin, vaporMax));
        } else {
            AtomicScience.logger.error("VaporHandler: Something tried to override vapor data for block: " + block);
        }
    }

    public static void allowVaporThrough(Block block) {
        if (!vaporPathMap.containsKey(block)) {
            vaporPathMap.put(block, new VaporPathData());
        }
    }

    public static int getVaporRate(World world, BlockPos pos) {
        return VaporHandler.getVaporRate(world, pos, MapHandler.THERMAL_MAP.getStoredHeat(world, pos));
    }

    public static int getVaporRate(World world, BlockPos pos, int heat) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (vaporDataMap.containsKey(block)) {
            return vaporDataMap.get(block).getVapor(world, pos, blockState, heat);
        }
        return 0;
    }

    public static boolean isSupportedVaporFluid(IBlockAccess world, BlockPos pos) {
        Block block;
        IBlockState state = world.func_180495_p(pos);
        if (state != null && vaporDataMap.containsKey(block = world.func_180495_p(pos).func_177230_c())) {
            return vaporDataMap.get(block).isSupported(world, pos, state);
        }
        return false;
    }

    public static boolean canSteamPassThrough(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state != null) {
            Block block = state.func_177230_c();
            if (vaporPathMap.containsKey(block)) {
                return vaporPathMap.get(block).canVaporPassThrough(world, pos, state);
            }
            if (state.func_185904_a() == Material.field_151586_h) {
                return true;
            }
            if (block.isAir(state, world, pos)) {
                return true;
            }
            if (!block.func_149703_v()) {
                return true;
            }
            AxisAlignedBB bb = state.func_185890_d(world, pos);
            return !(bb != null && bb.field_72340_a <= 0.0 && bb.field_72336_d >= 1.0 && bb.field_72339_c <= 0.0 && bb.field_72336_d >= 1.0);
        }
        return false;
    }

    static {
        VaporHandler.setVaporData((Block)Blocks.field_150358_i, () -> 100, () -> ConfigLogic.STEAM.WATER_FLOWING_VAPOR_RATE, () -> ConfigLogic.STEAM.WATER_VAPOR_MAX_RATE);
        VaporHandler.setVaporData((Block)Blocks.field_150355_j, () -> 100, () -> ConfigLogic.STEAM.WATER_VAPOR_RATE, () -> ConfigLogic.STEAM.WATER_VAPOR_MAX_RATE);
        VaporHandler.allowVaporThrough(Blocks.field_150415_aT);
        VaporHandler.allowVaporThrough(Blocks.field_150411_aY);
    }
}

