/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.atomic.lib.vapor;

import com.builtbroken.atomic.lib.vapor.IVaporData;
import com.builtbroken.atomic.lib.vapor.VaporCalculation;
import java.util.function.IntSupplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class VaporData
implements IVaporData {
    public IntSupplier heatMin;
    public IntSupplier vaporMax;
    public IntSupplier vaporMin;
    public VaporCalculation calculation;

    public VaporData(IntSupplier heat, IntSupplier vaporMin, IntSupplier vaporMax) {
        this.heatMin = heat;
        this.vaporMin = vaporMin;
        this.vaporMax = vaporMax;
    }

    @Override
    public int getVapor(World world, BlockPos pos, IBlockState state, int heat) {
        double heatMin = this.getHeatRequired(world, pos, state);
        if ((double)heat >= heatMin && heatMin > 0.0) {
            if (this.calculation != null) {
                return this.calculation.calculateVapor(world, pos, state, heat);
            }
            return (int)Math.min((double)this.getMax(world, pos, state), Math.ceil((double)this.getMin(world, pos, state) * ((double)heat / heatMin)));
        }
        return 0;
    }

    @Override
    public int getMin(World world, BlockPos pos, IBlockState state) {
        if (this.vaporMin != null) {
            return this.vaporMin.getAsInt();
        }
        return 0;
    }

    @Override
    public int getMax(World world, BlockPos pos, IBlockState state) {
        if (this.vaporMax != null) {
            return this.vaporMax.getAsInt();
        }
        return 0;
    }

    @Override
    public int getHeatRequired(World world, BlockPos pos, IBlockState state) {
        if (this.heatMin != null) {
            return this.heatMin.getAsInt();
        }
        return 0;
    }

    @Override
    public boolean isSupported(IBlockAccess world, BlockPos pos, IBlockState state) {
        return true;
    }
}

